/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import java.util.Map;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.cache.AbstractServiceImport;
import org.ops4j.peaberry.osgi.OSGiServiceAttributes;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiServiceImport<T>
extends AbstractServiceImport<T> {
    private final BundleContext bundleContext;
    private final ServiceReference ref;
    private final long id;
    private int rank;
    private final Map<String, ?> attributes;

    OSGiServiceImport(BundleContext bundleContext, ServiceReference ref) {
        this.bundleContext = bundleContext;
        this.ref = ref;
        this.id = this.getNumberProperty("service.id").longValue();
        this.rank = this.getNumberProperty("service.ranking").intValue();
        this.attributes = new OSGiServiceAttributes(ref);
    }

    @Override
    protected T acquireService() {
        return (T)this.bundleContext.getService(this.ref);
    }

    @Override
    public Map<String, ?> attributes() {
        return this.attributes;
    }

    @Override
    protected boolean hasRankingChanged() {
        int oldRank = this.rank;
        this.rank = this.getNumberProperty("service.ranking").intValue();
        return oldRank != this.rank;
    }

    @Override
    protected void releaseService(T o) {
        this.bundleContext.ungetService(this.ref);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof OSGiServiceImport) {
            return this.id == ((OSGiServiceImport)rhs).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    @Override
    public int compareTo(Import<T> rhs) {
        OSGiServiceImport rhsImport = (OSGiServiceImport)rhs;
        if (this.id == rhsImport.id) {
            return 0;
        }
        if (this.rank == rhsImport.rank) {
            return this.id < rhsImport.id ? -1 : 1;
        }
        return this.rank > rhsImport.rank ? -1 : 1;
    }

    private Number getNumberProperty(String key) {
        Object num = this.ref.getProperty(key);
        return num instanceof Number ? (Number)((Number)num) : (Number)0;
    }
}

