/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.spi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class LinkType {
    @JsonProperty(value="linkType")
    @NotNull
    public abstract String getId();

    @JsonIgnore
    @NotNull
    public String getLabel() {
        return this.getId();
    }

    @JsonIgnore
    @Nullable
    public abstract String getPrimaryLinkRefProperty();

    public boolean accepts(@NotNull LinkRequest linkRequest) {
        ValueMap props = linkRequest.getResourceProperties();
        String linkTypeId = (String)props.get("linkType", String.class);
        if (StringUtils.isNotEmpty((CharSequence)linkTypeId)) {
            return StringUtils.equals((CharSequence)linkTypeId, (CharSequence)this.getId());
        }
        String propertyName = this.getPrimaryLinkRefProperty();
        String linkRef = null;
        if (propertyName != null) {
            linkRef = (String)props.get(propertyName, String.class);
        }
        if (linkRef == null) {
            linkRef = linkRequest.getReference();
        }
        if (linkRef != null) {
            return this.accepts(linkRef);
        }
        return false;
    }

    public abstract boolean accepts(@NotNull String var1);

    @NotNull
    public abstract Link resolveLink(@NotNull Link var1);
}

