/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import com.day.cq.wcm.api.WCMMode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.markup.AbstractImageMediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.suffix.SuffixBuilder;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@Deprecated
@ConsumerType
public class DummyResponsiveImageMediaMarkupBuilder
extends AbstractImageMediaMarkupBuilder {
    @Self
    private Adaptable adaptable;
    @Self
    private UrlHandler urlHandler;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;

    @Override
    public final boolean accepts(@NotNull Media media) {
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        return (!media.isValid() || media.getRendition() == null) && this.getWcmMode() != null && this.getWcmMode() != WCMMode.DISABLED && mediaFormats != null && mediaFormats.length > 1 && mediaArgs.isDummyImage() && mediaArgs.isMediaFormatsMandatory();
    }

    @Override
    @SuppressFBWarnings(value={"STYLE"})
    public final HtmlElement<?> build(@NotNull Media media) {
        HtmlElement<?> mediaElement = this.getImageElement(media);
        JSONArray sources = this.getResponsiveImageSources(media);
        this.setResponsiveImageSource(mediaElement, sources, media);
        this.setAdditionalAttributes(mediaElement, media);
        MediaSource mediaSource = media.getMediaSource();
        if (mediaSource == null && !this.mediaHandlerConfig.getSources().isEmpty()) {
            Class<? extends MediaSource> mediaSourceClass = this.mediaHandlerConfig.getSources().iterator().next();
            mediaSource = (MediaSource)AdaptTo.notNull((Adaptable)this.adaptable, mediaSourceClass);
        }
        if (mediaSource != null) {
            mediaSource.enableMediaDrop(mediaElement, media.getMediaRequest());
        }
        return mediaElement;
    }

    protected HtmlElement<?> getImageElement(Media media) {
        Image img = (Image)new Image().addCssClass("wcmio_mediahandler_wcm_dummy");
        return img;
    }

    protected JSONArray getResponsiveImageSources(Media media) {
        MediaFormat[] mediaFormats = media.getMediaRequest().getMediaArgs().getMediaFormats();
        JSONArray sources = new JSONArray();
        for (MediaFormat mediaFormat : mediaFormats) {
            sources.put((Object)this.toReponsiveImageSource(media, mediaFormat));
        }
        return sources;
    }

    protected JSONObject toReponsiveImageSource(Media media, MediaFormat mediaFormat) {
        String url = this.buildDummyImageUrl(mediaFormat);
        try {
            JSONObject source = new JSONObject();
            source.put("mq", mediaFormat.getProperties().get((Object)"mq"));
            source.put("src", (Object)url);
            return source;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Error building JSON source.", ex);
        }
    }

    protected final String buildDummyImageUrl(MediaFormat format) {
        String suffix = new SuffixBuilder().put("width", (Object)format.getWidth()).put("height", (Object)format.getHeight()).put("mf", (Object)format.getLabel()).build();
        return this.urlHandler.get("/apps/wcm-io/handler/media/content/dummyImage").extension("png").suffix(suffix).build();
    }

    protected void setResponsiveImageSource(HtmlElement<?> mediaElement, JSONArray responsiveImageSources, Media media) {
        mediaElement.setData("resp-src", responsiveImageSources.toString());
    }

    @Override
    public final boolean isValidMedia(@NotNull HtmlElement<?> element) {
        return false;
    }
}

