/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap.template;

import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.so11y.bootstrap.BootstrapPluginSo11y;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class ConstructorInterTemplate {
    private static final String INTERCEPTOR_TYPE = "constructor";
    private static String PLUGIN_NAME;
    private static String TARGET_INTERCEPTOR;
    private static InstanceConstructorInterceptor INTERCEPTOR;
    private static IBootstrapLog LOGGER;
    private static BootstrapPluginSo11y PLUGIN_SO11Y;

    @RuntimeType
    public static void intercept(@This Object obj, @AllArguments Object[] allArguments) {
        long interceptorTimeCost = 0L;
        long startTime = System.nanoTime();
        try {
            ConstructorInterTemplate.prepare();
            EnhancedInstance targetObject = (EnhancedInstance)obj;
            if (INTERCEPTOR == null) {
                return;
            }
            INTERCEPTOR.onConstruct(targetObject, allArguments);
        }
        catch (Throwable t) {
            LOGGER.error("ConstructorInter failure.", t);
            PLUGIN_SO11Y.error(PLUGIN_NAME, INTERCEPTOR_TYPE);
        }
        PLUGIN_SO11Y.duration(interceptorTimeCost += System.nanoTime() - startTime);
    }

    private static void prepare() {
        if (INTERCEPTOR == null) {
            ClassLoader loader = BootstrapInterRuntimeAssist.getAgentClassLoader();
            if (loader != null) {
                IBootstrapLog logger = BootstrapInterRuntimeAssist.getLogger(loader, TARGET_INTERCEPTOR);
                if (logger != null) {
                    LOGGER = logger;
                    PLUGIN_SO11Y = BootstrapInterRuntimeAssist.getSO11Y(loader);
                    INTERCEPTOR = (InstanceConstructorInterceptor)BootstrapInterRuntimeAssist.createInterceptor(loader, TARGET_INTERCEPTOR, LOGGER);
                }
            } else {
                LOGGER.error("Runtime ClassLoader not found when create {}." + TARGET_INTERCEPTOR);
            }
        }
    }
}

