/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.Handler;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class RouteStateInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("methods:\\[([a-zA-Z,]+)\\]");

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        if (allArguments.length > 8) {
            objInst.setSkyWalkingDynamicField(allArguments[8]);
        } else if (VertxContext.VERTX_VERSION >= 35.0 && VertxContext.VERTX_VERSION <= 38.2) {
            try {
                Field field = objInst.getClass().getDeclaredField("contextHandlers");
                field.setAccessible(true);
                objInst.setSkyWalkingDynamicField(field.get(objInst));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String contextName;
        int lambdaOffset;
        RoutingContextImplBase routingContext = (RoutingContextImplBase)allArguments[0];
        List contextHandlers = (List)objInst.getSkyWalkingDynamicField();
        AtomicInteger currentContextIndex = (AtomicInteger)((EnhancedInstance)routingContext).getSkyWalkingDynamicField();
        int handlerContextIndex = currentContextIndex.get();
        if (VertxContext.VERTX_VERSION >= 35.0 && contextHandlers.size() > 1) {
            currentContextIndex.getAndIncrement();
        }
        if ((lambdaOffset = (contextName = ((Handler)contextHandlers.get(handlerContextIndex)).getClass().getCanonicalName()).indexOf("$$Lambda$")) > 0) {
            contextName = contextName.substring(0, lambdaOffset + 9);
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)String.format("%s.handle(RoutingContext)", contextName));
        Object connection = ((EnhancedInstance)routingContext.request()).getSkyWalkingDynamicField();
        VertxContext vertxContext = (VertxContext)((EnhancedInstance)connection).getSkyWalkingDynamicField();
        String routeMethods = null;
        if (VertxContext.VERTX_VERSION >= 37.1) {
            if (routingContext.currentRoute().methods() != null) {
                routeMethods = "{" + routingContext.currentRoute().methods().stream().map(Enum::toString).collect(Collectors.joining(",")) + "}";
            }
        } else {
            Matcher matcher = HTTP_METHOD_PATTERN.matcher(routingContext.currentRoute().toString());
            if (matcher.find()) {
                routeMethods = "{" + matcher.group(1) + "}";
            }
        }
        if (routeMethods != null && routingContext.currentRoute().getPath() != null) {
            vertxContext.getSpan().setOperationName(routeMethods + routingContext.currentRoute().getPath());
        }
        ContextManager.continued((ContextSnapshot)vertxContext.getContextSnapshot());
        span.setComponent((Component)ComponentsDefine.VERTX);
        SpanLayer.asHttp((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

