/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.testcase.xxljob.controller;

import lombok.extern.log4j.Log4j2;
import org.apache.skywalking.apm.testcase.xxljob.service.XXLJobServerControlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/case")
@Log4j2
public class CaseController {

    private static final String SUCCESS = "Success";

    @Autowired
    private XXLJobServerControlService xxlJobServerControlService;

    @RequestMapping("/simpleJob")
    @ResponseBody
    public String simpleJob() {
        return SUCCESS;
    }

    @RequestMapping("/methodJob")
    @ResponseBody
    public String methodJob() {
        return SUCCESS;
    }

    @RequestMapping("/glueJob")
    @ResponseBody
    public String glueJob() {
        return SUCCESS;
    }

    @RequestMapping("/healthCheck")
    @ResponseBody
    public String healthCheck() throws Exception {

        xxlJobServerControlService.checkCurrentExecutorRegistered();

        return SUCCESS;
    }

    @RequestMapping("/call")
    @ResponseBody
    public String call() {
        return SUCCESS;
    }
}
