/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.encoding.StreamEncoderFactories;
import com.linecorp.armeria.internal.common.encoding.StreamEncoderFactory;
import io.netty.handler.codec.compression.Brotli;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class HttpEncoders {
    @Nullable
    static StreamEncoderFactory getEncoderFactory(RequestHeaders headers) {
        String acceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING);
        if (acceptEncoding == null) {
            return null;
        }
        return HttpEncoders.determineEncoder(acceptEncoding);
    }

    @Nullable
    private static StreamEncoderFactory determineEncoder(String acceptEncoding) {
        Map.Entry entry;
        float starQ = -1.0f;
        LinkedHashMap<StreamEncoderFactories, Float> encodings = new LinkedHashMap<StreamEncoderFactories, Float>();
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("br") && Brotli.isAvailable()) {
                encodings.put(StreamEncoderFactories.BROTLI, Float.valueOf(q));
                continue;
            }
            if (encoding.contains("gzip")) {
                encodings.put(StreamEncoderFactories.GZIP, Float.valueOf(q));
                continue;
            }
            if (encoding.contains("deflate")) {
                encodings.put(StreamEncoderFactories.DEFLATE, Float.valueOf(q));
                continue;
            }
            if (!encoding.contains("x-snappy-framed")) continue;
            encodings.put(StreamEncoderFactories.SNAPPY, Float.valueOf(q));
        }
        if (!encodings.isEmpty() && ((Float)(entry = Collections.max(encodings.entrySet(), Map.Entry.comparingByValue())).getValue()).floatValue() > 0.0f) {
            return (StreamEncoderFactory)entry.getKey();
        }
        if (starQ > 0.0f) {
            if (!encodings.containsKey(StreamEncoderFactories.BROTLI) && Brotli.isAvailable()) {
                return StreamEncoderFactories.BROTLI;
            }
            if (!encodings.containsKey(StreamEncoderFactories.GZIP)) {
                return StreamEncoderFactories.GZIP;
            }
            if (!encodings.containsKey(StreamEncoderFactories.DEFLATE)) {
                return StreamEncoderFactories.DEFLATE;
            }
            if (!encodings.containsKey(StreamEncoderFactories.SNAPPY)) {
                return StreamEncoderFactories.SNAPPY;
            }
        }
        return null;
    }

    private HttpEncoders() {
    }

    static {
        Brotli.isAvailable();
    }
}

