/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.loadbalancer;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.loadbalancer.AbstractRampingUpLoadBalancerBuilder;
import com.linecorp.armeria.common.loadbalancer.RampingUpLoadBalancer;
import com.linecorp.armeria.common.loadbalancer.UpdatableLoadBalancer;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.function.ToIntFunction;

@UnstableApi
public final class RampingUpLoadBalancerBuilder<T>
extends AbstractRampingUpLoadBalancerBuilder<T, RampingUpLoadBalancerBuilder<T>> {
    private final List<T> candidates;
    @Nullable
    private final ToIntFunction<T> weightFunction;

    RampingUpLoadBalancerBuilder(Iterable<T> candidates, @Nullable ToIntFunction<T> weightFunction) {
        this.candidates = ImmutableList.copyOf(candidates);
        this.weightFunction = weightFunction;
    }

    public UpdatableLoadBalancer<T> build() {
        this.validate();
        EventExecutor executor = this.executor();
        if (executor == null) {
            executor = CommonPools.workerGroup().next();
        }
        return new RampingUpLoadBalancer<T>(this.candidates, this.weightFunction, this.rampingUpIntervalMillis(), this.totalSteps(), this.rampingUpTaskWindowMillis(), this.weightTransition(), this.timestampFunction(), this.ticker(), executor);
    }
}

