/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorage;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.InternalThreadLocalMap;
import java.util.Objects;

enum ThreadLocalRequestContextStorage implements RequestContextStorage
{
    INSTANCE;

    private static final FastThreadLocal<RequestContext> context;

    @Override
    @Nullable
    public <T extends RequestContext> T push(RequestContext toPush) {
        Objects.requireNonNull(toPush, "toPush");
        InternalThreadLocalMap map = InternalThreadLocalMap.get();
        RequestContext oldCtx = context.get(map);
        context.set(map, toPush);
        return (T)oldCtx;
    }

    @Override
    public void pop(RequestContext current, @Nullable RequestContext toRestore) {
        Objects.requireNonNull(current, "current");
        InternalThreadLocalMap map = InternalThreadLocalMap.get();
        RequestContext contextInThreadLocal = context.get(map);
        if (contextInThreadLocal == null || current.unwrapAll() != contextInThreadLocal.unwrapAll()) {
            throw RequestContextUtil.newIllegalContextPoppingException(current, contextInThreadLocal);
        }
        context.set(map, toRestore);
    }

    @Override
    @Nullable
    public <T extends RequestContext> T currentOrNull() {
        return (T)context.get();
    }

    static {
        context = new FastThreadLocal();
    }
}

