## 10.1.0

#### A Version of PERFORMANCE
* **Huge UI Performance Improvement. Metrics widgets queries are bundled by leveraging the GraphQL capabilities.**
* **Parallel Queries Support in GraphQL engine. Improve query performance.**
* **Significantly improve the performance of OTEL metrics handler. Reduce CPU and GC costs in OTEL metrics processes.**
* **With adopting BanyanDB 0.7, native database performance and stability are improved.**

#### Project

* E2E: bump up the version of the opentelemetry-collector to 0.102.1.
* Push snapshot data-generator docker image to ghcr.io.
* Bump up skywalking-infra-e2e to work around GHA removing `docker-compose` v1.
* Bump up CodeQL GitHub Actions.
* Fix wrong phase of delombok plugin to reduce build warnings.
* Use ci-friendly revision to set the project version.

#### OAP Server

* Fix wrong indices in the eBPF Profiling related models.
* Support exclude the specific namespaces traffic in the eBPF Access Log receiver.
* Add Golang as a supported language for Elasticsearch.
* Remove unnecessary BanyanDB flushing logs(info).
* Increase `SW_CORE_GRPC_MAX_MESSAGE_SIZE` to 50MB.
* Support to query relation metrics through PromQL.
* Support trace MQE query for debugging.
* Add Component ID(158) for the Solon framework.
* Fix metrics tag in HTTP handler of browser receiver plugin.
* Increase `alarm_record#message` column length to 2000 from 200.
* Remove `alarm_record#message` column indexing.
* Add Python as a supported language for Pulsar.
* Make more proper histogram buckets for the `persistence_timer_bulk_prepare_latency`,
  `persistence_timer_bulk_execute_latency` and `persistence_timer_bulk_all_latency` metrics in PersistenceTimer.
* [Break Change] Update Nacos version to 2.3.2. Nacos 1.x server can't serve as cluster coordinator and configuration server.
* Support tracing trace query(SkyWalking and Zipkin) for debugging.
* Fix BanyanDB metrics query: used the wrong `Downsampling` type to find the schema.
* Support fetch cilium flow to monitoring network traffic between cilium services.
* Support `labelCount` function in the OAL engine.
* Support BanyanDB internal measure query execution tracing.
* BanyanDB client config: rise the default `maxBulkSize` to 10000, add `flushTimeout` and set default to 10s.
* Polish BanyanDB group and schema creation logic to fix the schema creation failure issue in distributed race conditions.
* Support tracing topology query for debugging.
* Fix expression of graph `Current QPS` in MySQL dashboard.
* Support tracing logs query for debugging.
* BanyanDB: fix Tag autocomplete data storage and query.
* Support aggregation operators in PromQL query.
* Update the kubernetes HTTP latency related metrics source unit from `ns` to `ms`.
* Support BanyanDB internal stream query execution tracing.
* Fix Elasticsearch, MySQL, RabbitMQ dashboards typos and missing expressions.
* BanyanDB: Zipkin Module set service as Entity for improving the query performance.
* MQE: check the metrics value before do binary operation to improve robustness.
* Replace workaround with Armeria native supported context path.
* Add an http endpoint wrapper for health check.
* Bump up Armeria and transitive dependencies.
* BanyanDB: if the model column is already a `@BanyanDB.TimestampColumn`, set `@BanyanDB.NoIndexing` on it to reduce indexes.
* BanyanDB: stream sort-by `time` query, use internal time-series rather than `index` to improve the query performance.
* Bump up graphql-java to 21.5.
* Add Unknown Node when receive Kubernetes peer address is not aware in current cluster.
* Fix CounterWindow concurrent increase cause NPE by PriorityQueue
* Fix format the endpoint name with empty string.
* Support async query for the composite GraphQL query.
* Get endpoint list order by timestamp desc.
* Support sort queries on metrics generated by eBPF receiver.
* Fix the compatibility with Grafana 11 when using label_values query variables.
* Nacos as config server and cluster coordinator supports configuration contextPath.
* Update the endpoint name format to `<Method>:<Path>` in eBPF Access Log Receiver.
* Add self-observability metrics for OpenTelemetry receiver.
* Support service level metrics aggregate when missing pod context in eBPF Access Log Receiver.
* Fix query `getGlobalTopology` throw exception when didn't find any services by the given Layer.
* Fix the previous analysis result missing in the ALS `k8s-mesh` analyzer.
* Fix `findEndpoint` query requires `keyword` when using BanyanDB.
* Support to analysis the ztunnel mapped IP address and mTLS mode in eBPF Access Log Receiver.
* Adapt BanyanDB Java Client 0.7.0.
* Add SkyWalking Java Agent self observability dashboard.
* Add Component ID(5022) for the GoFrame framework.
* Bump up protobuf java dependencies to 3.25.5.
* BanyanDB: support using native term searching for `keyword` in query `findEndpoint` and `getAlarm`.
* BanyanDB: support TLS connection and configuration.
* PromQL service: query API support RFC3399 time format.
* Improve the performance of OTEL metrics handler.
* PromQL service: fix operators result missing `rangeExpression` flag.
* BanyanDB: use `TimestampRange` to improve "events" query for BanyanDB.
* Optimize `network_address_alias` table to reduce the number of the index.
* PromQL service: support round brackets operator.
* Support query Alarm message Tag for auto-complete.
* Add SkyWalking Go Agent self observability dashboard.

#### UI

* Highlight search log keywords.
* Add Error URL in the browser log.
* Add a SolonMVC icon.
* Adding cilium icon and i18n for menu.
* Fix the mismatch between the unit and calculation of the "Network Bandwidth Usage" widget in Windows-Service Dashboard.
* Make a maximum 20 entities per query in service/instance/endpoint list widgets.
* Polish error nodes in trace widget.
* Introduce flame graph to the trace profiling.
* Correct services and instances when changing page numbers.
* Improve metric queries to make page opening brisker.
* Bump up dependencies to fix CVEs.
* Add a loading view for initialization page.
* Fix a bug for selectors when clicking the refresh icon.
* Fix health check to OAP backend.
* Add `Service`, `ServiceInstance`, `Endpoint` dashboard forwarder to Kubernetes Topologies.
* Fix pagination for service/instance list widgets.
* Add queries for alarm tags.
* Add skywalking java agent self observability menu.

#### Documentation

* Update the version description supported by zabbix receiver.
* Move the Official Dashboard docs to marketplace docs.
* Add marketplace introduction docs under `quick start` menu to reduce the confusion of finding feature docs.
* Update Windows Metrics(Swap -> Virtual Memory)


All issues and pull requests are [here](https://github.com/apache/skywalking/milestone/205?closed=1)
