/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.internal.Resources;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class OperationView
extends AbstractOperation {
    private static final long serialVersionUID = -4679426189917900959L;
    private final AbstractOperation source;
    private final GenericName valueType;

    OperationView(AbstractOperation source, GenericName valueType) {
        super(Map.of("inheritFrom", source));
        this.source = source;
        this.valueType = valueType;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return this.source.getParameters();
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.source.getResult();
    }

    @Override
    public Set<String> getDependencies() {
        return Set.of();
    }

    @Override
    public Object apply(AbstractFeature instance, ParameterValueGroup parameters) {
        try {
            return this.source.apply(instance, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(Resources.format((short)26, 1, this.getName(), this.valueType, instance.getType().getName()), e);
        }
    }

    @Override
    public String toString() {
        return this.source.toString();
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() * 37;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof OperationView && this.source.equals(((OperationView)obj).source);
    }
}

