/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class TranslatedTransform
extends AbstractMathTransform {
    private final int dimension;
    private final double offset;
    private final double tolerance;
    private final MathTransform transform;

    private TranslatedTransform(int dimension, double offset, MathTransform transform) {
        this.dimension = dimension;
        this.offset = offset;
        this.tolerance = Math.abs(offset) * 1.0E-13;
        this.transform = transform;
    }

    static MathTransform resolveNaN(MathTransform crsToGrid, GridGeometry gridGeometry) throws NoninvertibleTransformException {
        MathTransform analyzing = MathTransforms.getLastStep((MathTransform)crsToGrid);
        Matrix toGrid = MathTransforms.getMatrix((MathTransform)analyzing);
        if (toGrid != null) {
            long dimensionBitMask = 0L;
            long zeroingGridIndex = 0L;
            int j = toGrid.getNumRow() - 1;
            while (--j >= 0) {
                int i = toGrid.getNumCol() - 1;
                if (!Double.isNaN(toGrid.getElement(j, i))) continue;
                while (--i >= 0) {
                    if (!Double.isNaN(toGrid.getElement(j, i))) continue;
                    dimensionBitMask |= 1L << i;
                    zeroingGridIndex |= 1L << j;
                    if ((i | j) < 64) continue;
                    throw new ArithmeticException(Errors.format((short)50, (Object)(Math.max(i, j) + 1)));
                }
            }
            if (zeroingGridIndex != 0L) {
                Matrix fallback;
                Matrix fromGrid;
                MathTransform fromCenter = MathTransforms.getFirstStep((MathTransform)gridGeometry.gridToCRS);
                MathTransform fromCorner = MathTransforms.getFirstStep((MathTransform)gridGeometry.cornerToCRS);
                if (Utilities.equalsApproximately((Object)(analyzing = analyzing.inverse()), (Object)fromCenter) || Utilities.equalsApproximately((Object)analyzing, (Object)fromCorner)) {
                    fromGrid = MathTransforms.getMatrix((MathTransform)fromCenter);
                    fallback = MathTransforms.getMatrix((MathTransform)fromCorner);
                    if (fromGrid == null) {
                        fromGrid = fallback;
                        fallback = null;
                    }
                } else {
                    fromGrid = MathTransforms.getMatrix((MathTransform)analyzing);
                    fallback = null;
                }
                if (fromGrid != null) {
                    int translationColumn = fromGrid.getNumCol() - 1;
                    double[] offsets = new double[fromGrid.getNumRow()];
                    offsets[offsets.length - 1] = 1.0;
                    while (dimensionBitMask != 0L) {
                        int j2 = Long.numberOfTrailingZeros(dimensionBitMask);
                        dimensionBitMask &= 1L << j2 ^ 0xFFFFFFFFFFFFFFFFL;
                        double offset = fromGrid.getElement(j2, translationColumn);
                        if (Double.isNaN(offset) && (fallback == null || Double.isNaN(offset = fallback.getElement(j2, translationColumn)))) {
                            zeroingGridIndex &= 1L << j2 ^ 0xFFFFFFFFFFFFFFFFL;
                            continue;
                        }
                        offsets[j2] = offset;
                    }
                    if (zeroingGridIndex != 0L) {
                        int j3;
                        MatrixSIS translated = Matrices.copy((Matrix)toGrid);
                        translated.translate(offsets);
                        do {
                            j3 = Long.numberOfTrailingZeros(zeroingGridIndex);
                            translated.setElement(j3, translated.getNumCol() - 1, 0.0);
                        } while ((zeroingGridIndex &= 1L << j3 ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                        List steps = MathTransforms.getSteps((MathTransform)crsToGrid);
                        crsToGrid = MathTransforms.linear((Matrix)translated);
                        for (int dimension = offsets.length - 2; dimension >= 0; --dimension) {
                            double offset = offsets[dimension];
                            if (offset == 0.0) continue;
                            crsToGrid = new TranslatedTransform(dimension, offset, (MathTransform)crsToGrid);
                        }
                        for (int i = steps.size() - 2; i >= 0; --i) {
                            crsToGrid = MathTransforms.concatenate((MathTransform)((MathTransform)steps.get(i)), (MathTransform)crsToGrid);
                        }
                    }
                }
            }
        }
        return crsToGrid;
    }

    public int getSourceDimensions() {
        return this.transform.getSourceDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getTargetDimensions();
    }

    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix derivative = null;
        if (derivate) {
            double[] coordinates = Arrays.copyOfRange(srcPts, srcOff, srcOff + this.getSourceDimensions());
            int n = this.dimension;
            double d = coordinates[n] = coordinates[n] - this.offset;
            if (Math.abs(d) < this.tolerance) {
                coordinates[this.dimension] = 0.0;
            }
            derivative = this.transform.derivative((DirectPosition)new DirectPositionView.Double(coordinates));
        }
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivative;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcDim = this.getSourceDimensions();
        int stop = srcOff + numPts * srcDim;
        for (int i = srcOff + this.dimension; i < stop; i += srcDim) {
            int n = i;
            double d = srcPts[n] = srcPts[n] - this.offset;
            if (!(Math.abs(d) < this.tolerance)) continue;
            srcPts[i] = 0.0;
        }
        this.transform.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }
}

