/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rabbitmq.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.LZ4CompressData;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.rabbitmq.config.RabbitmqLogCollectConfig;
import org.springframework.lang.NonNull;

public class RabbitmqLogCollectClient
extends AbstractLogConsumeClient<RabbitmqLogCollectConfig.RabbitmqLogConfig, ShenyuRequestLog> {
    private String exchangeName;
    private Connection connection;
    private Channel channel;
    private String routingKey;

    public void initClient0(@NonNull RabbitmqLogCollectConfig.RabbitmqLogConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getHost()) || Objects.isNull(config.getPort()) || StringUtils.isBlank((CharSequence)config.getExchangeName()) || StringUtils.isBlank((CharSequence)config.getQueueName()) || StringUtils.isBlank((CharSequence)config.getExchangeType())) {
            LOG.error("rabbitmq prop is empty. failed init rabbit producer");
            return;
        }
        String queueName = config.getQueueName();
        this.exchangeName = config.getExchangeName();
        this.routingKey = config.getRoutingKey();
        ConnectionFactory factory = new ConnectionFactory();
        factory.setVirtualHost(config.getVirtualHost());
        factory.setHost(config.getHost());
        factory.setPort(config.getPort().intValue());
        factory.setUsername(config.getUsername());
        factory.setPassword(config.getPassword());
        try {
            this.connection = factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.exchangeDeclare(this.exchangeName, config.getExchangeType(), true);
            this.channel.queueDeclare(queueName, config.getDurable().booleanValue(), config.getExclusive().booleanValue(), config.getAutoDelete().booleanValue(), config.getArgs());
            this.channel.queueBind(queueName, this.exchangeName, this.routingKey);
            LOG.info("init rabbitmqLogCollectClient success");
        }
        catch (IOException e) {
            LOG.error("failed to initialize Rabbitmq connection", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("failed to connect rabbitmq, connect timeout", (Throwable)e);
        }
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        logs.forEach(log -> {
            try {
                this.channel.basicPublish(this.exchangeName, this.routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, this.buildLogMessageBytes((ShenyuRequestLog)log));
            }
            catch (Exception e) {
                LOG.error("rabbitmq push logs error", (Throwable)e);
            }
        });
    }

    private byte[] buildLogMessageBytes(ShenyuRequestLog log) {
        byte[] bytes = JsonUtils.toJson((Object)log).getBytes(StandardCharsets.UTF_8);
        LZ4CompressData lz4CompressData = new LZ4CompressData(bytes.length, this.compressedByte(bytes));
        bytes = JsonUtils.toJson((Object)lz4CompressData).getBytes();
        return bytes;
    }

    private byte[] compressedByte(byte[] srcByte) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        return compressor.compress(srcByte);
    }

    public void close0() throws Exception {
        try {
            if (Objects.nonNull(this.channel)) {
                this.channel.close();
            }
            if (Objects.nonNull(this.connection)) {
                this.connection.close();
            }
            LOG.info("close RabbitMQ connection success");
        }
        catch (IOException e) {
            LOG.error("failed to close RabbitMQ connection", (Throwable)e);
        }
    }
}

