/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.utils;

import java.util.List;
import java.util.function.Function;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.base.support.RequestDecorator;
import org.apache.shenyu.plugin.base.support.ResponseDecorator;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerWebExchangeUtils {
    public static Mono<ServerWebExchange> rewriteRequestBody(ServerWebExchange exchange, List<HttpMessageReader<?>> readers, Function<String, Mono<String>> convert) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, readers);
        CachedBodyOutputMessage outputMessage = ResponseUtils.newCachedBodyOutputMessage(exchange);
        return serverRequest.bodyToMono(String.class).switchIfEmpty(Mono.just((Object)"")).flatMap(convert).flatMap(body -> {
            BodyInserter bodyInserter = BodyInserters.fromValue((Object)body);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext());
        }).then(Mono.defer(() -> {
            RequestDecorator decorator = new RequestDecorator(exchange, outputMessage);
            return Mono.just((Object)exchange.mutate().request((ServerHttpRequest)decorator).build());
        })).onErrorResume(throwable -> ResponseUtils.release(outputMessage, throwable));
    }

    public static ServerWebExchange rewriteResponseBody(ServerWebExchange exchange, Function<String, String> convert) {
        return exchange.mutate().response((ServerHttpResponse)new ResponseDecorator(exchange, convert)).build();
    }
}

