/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.processors.ComponentsProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.PathsProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenAPIResolver {
    private final OpenAPI openApi;
    private final ResolverCache cache;
    private final ComponentsProcessor componentsProcessor;
    private final PathsProcessor pathProcessor;
    private final OperationProcessor operationsProcessor;
    private Settings settings = new Settings();
    private Set<String> resolveValidationMessages = new HashSet<String>();

    public ResolverCache getCache() {
        return this.cache;
    }

    public OpenAPIResolver(OpenAPI openApi) {
        this(openApi, null, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths) {
        this(openApi, auths, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Settings settings) {
        this(openApi, auths, parentFileLocation, settings, new ParseOptions());
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Settings settings, ParseOptions parseOptions) {
        this.openApi = openApi;
        this.settings = settings != null ? settings : new Settings();
        this.cache = new ResolverCache(openApi, auths, parentFileLocation, this.resolveValidationMessages, parseOptions);
        this.componentsProcessor = new ComponentsProcessor(openApi, this.cache);
        this.pathProcessor = new PathsProcessor(this.cache, openApi, this.settings);
        this.operationsProcessor = new OperationProcessor(this.cache, openApi);
    }

    public void resolve(SwaggerParseResult result) {
        OpenAPI resolved = this.resolve();
        if (resolved == null) {
            return;
        }
        result.setOpenAPI(resolved);
        result.getMessages().addAll(this.resolveValidationMessages);
    }

    public OpenAPI resolve() {
        if (this.openApi == null) {
            return null;
        }
        this.pathProcessor.processPaths();
        this.componentsProcessor.processComponents();
        if (this.openApi.getPaths() != null) {
            for (String pathname : this.openApi.getPaths().keySet()) {
                PathItem pathItem = (PathItem)this.openApi.getPaths().get((Object)pathname);
                if (pathItem.readOperations() == null) continue;
                for (Operation operation : pathItem.readOperations()) {
                    this.operationsProcessor.processOperation(operation);
                }
            }
        }
        return this.openApi;
    }

    public static class Settings {
        private boolean addParametersToEachOperation = true;

        public boolean addParametersToEachOperation() {
            return this.addParametersToEachOperation;
        }

        public Settings addParametersToEachOperation(boolean addParametersToEachOperation) {
            this.addParametersToEachOperation = addParametersToEachOperation;
            return this;
        }
    }
}

