/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseIntegerValue;
import com.clickhouse.client.data.ClickHouseLongValue;
import com.clickhouse.client.data.ClickHouseOffsetDateTimeValue;
import com.clickhouse.client.data.ClickHouseStringValue;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.plugin.logging.clickhouse.config.ClickHouseLogCollectConfig;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.springframework.lang.NonNull;

public class ClickHouseLogCollectClient
extends AbstractLogConsumeClient<ClickHouseLogCollectConfig.ClickHouseLogConfig, ShenyuRequestLog> {
    private ClickHouseClient client;
    private ClickHouseNode endpoint;
    private String database;

    public void consume0(@NonNull List<ShenyuRequestLog> logs) throws Exception {
        if (CollectionUtils.isNotEmpty(logs)) {
            Object[][] datas = new Object[logs.size()][];
            for (int i = 0; i < logs.size(); ++i) {
                Object[] data = new Object[]{DateUtils.parseLocalDateTime((String)logs.get(i).getTimeLocal(), (String)"yyyy-MM-dd HH:mm:ss.SSS"), logs.get(i).getClientIp(), logs.get(i).getMethod(), logs.get(i).getRequestHeader(), logs.get(i).getResponseHeader(), logs.get(i).getQueryParams(), logs.get(i).getRequestBody(), logs.get(i).getRequestUri(), logs.get(i).getResponseBody(), logs.get(i).getResponseContentLength(), logs.get(i).getRpcType(), logs.get(i).getStatus(), logs.get(i).getUpstreamIp(), logs.get(i).getUpstreamResponseTime(), logs.get(i).getUserAgent(), logs.get(i).getHost(), logs.get(i).getModule(), logs.get(i).getTraceId(), logs.get(i).getPath()};
                datas[i] = data;
            }
            ClickHouseClient.send((ClickHouseNode)this.endpoint, (String)String.format("INSERT INTO `%s`.request_log_distributed(timeLocal, clientIp, method, requestHeader, responseHeader, queryParams, requestBody, requestUri, responseBody, responseContentLength, rpcType, status, upstreamIp, upstreamResponseTime, userAgent, host, module, traceId, path) VALUES (:timeLocal, :clientIp,:method, :requestHeader, :responseHeader, :queryParams, :requestBody, :requestUri, :responseBody, :responseContentLength, :rpcType, :status, :upstreamIp, :upstreamResponseTime, :userAgent, :host, :module, :traceId, :path);", this.database), (ClickHouseValue[])new ClickHouseValue[]{ClickHouseOffsetDateTimeValue.ofNull((int)3, (TimeZone)TimeZone.getTimeZone("Asia/Shanghai")), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseIntegerValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseIntegerValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseLongValue.ofNull((boolean)false), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull(), ClickHouseStringValue.ofNull()}, (Object[][])datas).get();
        }
    }

    public void close0() {
        if (Objects.nonNull(this.client)) {
            this.client.close();
        }
    }

    public void initClient0(@NonNull ClickHouseLogCollectConfig.ClickHouseLogConfig config) {
        String username = config.getUsername();
        String password = config.getPassword();
        String ttl = config.getTtl().isEmpty() ? "30" : config.getTtl();
        this.database = config.getDatabase();
        this.endpoint = ClickHouseNode.builder().host(config.getHost()).port(ClickHouseProtocol.HTTP, Integer.valueOf(config.getPort())).credentials(ClickHouseCredentials.fromUserAndPassword((String)username, (String)password)).build();
        try {
            this.client = ClickHouseClient.builder().build();
            ClickHouseRequest request = this.client.connect(this.endpoint).format(ClickHouseFormat.TabSeparatedWithNamesAndTypes);
            request.query(String.format("create database if not exists `%s`", this.database)).executeAndWait();
            request.query(String.format("create table if not exists `%s`.request_log(\n    timeLocal   DateTime64,\n    clientIp String,\n    method  String,\n    requestHeader   String,\n    responseHeader  String,\n    queryParams String,\n    requestBody String,\n    requestUri  String,\n    responseBody    String,\n    responseContentLength UInt64,\n    rpcType String,\n    status  UInt16,\n    upstreamIp  String,\n    upstreamResponseTime UInt128,\n    userAgent String,\n    host    String,\n    module  String,\n    traceId String,\n    path    String\n) ENGINE = %s()\nORDER BY (timeLocal,clientIp,method,rpcType,upstreamIp,upstreamResponseTime)\n TTL toDateTime(timeLocal) + INTERVAL %s DAY \n;", this.database, config.getEngine(), ttl)).executeAndWait();
            request.query(String.format("create table if not exists `%s`.request_log_distributed\n AS `%s`.request_log ENGINE = Distributed('%s', '%s', 'request_log', rand());", this.database, this.database, config.getClusterName(), this.database)).executeAndWait();
        }
        catch (Exception e) {
            LOG.error("inti ClickHouseLogClient error", (Throwable)e);
        }
    }
}

