/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.httpclient;

import java.util.Objects;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.httpclient.NettyHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.WebClientPlugin;
import org.apache.shenyu.plugin.httpclient.config.HttpClientProperties;
import org.apache.shenyu.springboot.starter.plugin.httpclient.HttpClientFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.LoopResources;

@Configuration
public class HttpClientPluginConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.httpclient")
    public HttpClientProperties httpClientProperties() {
        return new HttpClientProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.httpclient.thread-pool.prefix"})
    public LoopResources httpClientLoopResource(HttpClientProperties properties) {
        HttpClientProperties.ThreadPool threadPool = properties.getThreadPool();
        return LoopResources.create((String)threadPool.getPrefix(), (int)threadPool.getSelectCount(), (int)threadPool.getWorkerCount(), (boolean)threadPool.getDaemon());
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpClient.class, HttpClientFactory.class})
    public HttpClientFactory httpClient(HttpClientProperties properties, ObjectProvider<LoopResources> provider, ServerProperties serverProperties) {
        return new HttpClientFactory(properties, (LoopResources)provider.getIfAvailable(), serverProperties);
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="netty", matchIfMissing=true)
    static class NettyHttpClientConfiguration {
        NettyHttpClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin nettyHttpClientPlugin(ObjectProvider<HttpClient> httpClient) {
            return new NettyHttpClientPlugin((HttpClient)httpClient.getIfAvailable());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="webClient")
    static class WebClientConfiguration {
        WebClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin webClientPlugin(HttpClientProperties properties, ObjectProvider<HttpClient> httpClient) {
            WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(properties.getMaxInMemorySize() * 0x100000)).build()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(Objects.requireNonNull((HttpClient)httpClient.getIfAvailable()))).build();
            return new WebClientPlugin(webClient);
        }
    }
}

