/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_service_credentials;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.security.get_service_credentials.NodesCredentialsFileToken;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class NodesCredentials
implements JsonpSerializable {
    private final NodeStatistics nodeStats;
    private final Map<String, NodesCredentialsFileToken> fileTokens;
    public static final JsonpDeserializer<NodesCredentials> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodesCredentials::setupNodesCredentialsDeserializer);

    private NodesCredentials(Builder builder) {
        this.nodeStats = ApiTypeHelper.requireNonNull(builder.nodeStats, this, "nodeStats");
        this.fileTokens = ApiTypeHelper.unmodifiableRequired(builder.fileTokens, (Object)this, "fileTokens");
    }

    public static NodesCredentials of(Function<Builder, ObjectBuilder<NodesCredentials>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    public final Map<String, NodesCredentialsFileToken> fileTokens() {
        return this.fileTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fileTokens)) {
            generator.writeKey("file_tokens");
            generator.writeStartObject();
            for (Map.Entry<String, NodesCredentialsFileToken> item0 : this.fileTokens.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodesCredentialsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes");
        op.add(Builder::fileTokens, JsonpDeserializer.stringMapDeserializer(NodesCredentialsFileToken._DESERIALIZER), "file_tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodesCredentials> {
        private NodeStatistics nodeStats;
        private Map<String, NodesCredentialsFileToken> fileTokens;

        public final Builder nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this;
        }

        public final Builder nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        public final Builder fileTokens(Map<String, NodesCredentialsFileToken> map) {
            this.fileTokens = Builder._mapPutAll(this.fileTokens, map);
            return this;
        }

        public final Builder fileTokens(String key, NodesCredentialsFileToken value) {
            this.fileTokens = Builder._mapPut(this.fileTokens, key, value);
            return this;
        }

        public final Builder fileTokens(String key, Function<NodesCredentialsFileToken.Builder, ObjectBuilder<NodesCredentialsFileToken>> fn) {
            return this.fileTokens(key, fn.apply(new NodesCredentialsFileToken.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesCredentials build() {
            this._checkSingleUse();
            return new NodesCredentials(this);
        }
    }
}

