/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.ChunkingMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChunkingConfig
implements JsonpSerializable {
    private final ChunkingMode mode;
    @Nullable
    private final Time timeSpan;
    public static final JsonpDeserializer<ChunkingConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChunkingConfig::setupChunkingConfigDeserializer);

    private ChunkingConfig(Builder builder) {
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.timeSpan = builder.timeSpan;
    }

    public static ChunkingConfig of(Function<Builder, ObjectBuilder<ChunkingConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ChunkingMode mode() {
        return this.mode;
    }

    @Nullable
    public final Time timeSpan() {
        return this.timeSpan;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.timeSpan != null) {
            generator.writeKey("time_span");
            this.timeSpan.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChunkingConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, ChunkingMode._DESERIALIZER, "mode");
        op.add(Builder::timeSpan, Time._DESERIALIZER, "time_span");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChunkingConfig> {
        private ChunkingMode mode;
        @Nullable
        private Time timeSpan;

        public final Builder mode(ChunkingMode value) {
            this.mode = value;
            return this;
        }

        public final Builder timeSpan(@Nullable Time value) {
            this.timeSpan = value;
            return this;
        }

        public final Builder timeSpan(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeSpan(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChunkingConfig build() {
            this._checkSingleUse();
            return new ChunkingConfig(this);
        }
    }
}

