/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.plugin.logging.common.client.LogConsumeClient;
import org.apache.shenyu.plugin.logging.common.config.GenericGlobalConfig;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.ObjectUtils;

public abstract class AbstractLogConsumeClient<T extends GenericGlobalConfig, L extends ShenyuRequestLog>
implements LogConsumeClient<T, L> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractLogConsumeClient.class);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicReference<Thread> closeThread = new AtomicReference();

    public abstract void initClient0(@NonNull T var1);

    public abstract void consume0(@NonNull List<L> var1) throws Exception;

    public abstract void close0() throws Exception;

    @Override
    public void initClient(T config) {
        if (this.isStarted.get()) {
            this.close();
        }
        if (ObjectUtils.isEmpty(config)) {
            LOG.error("{} config is null, client not init.", (Object)this.getClass().getSimpleName());
            return;
        }
        this.initClient0(config);
        this.isStarted.set(true);
        this.closeThread.set(new Thread(this::close));
        Runtime.getRuntime().addShutdownHook(this.closeThread.get());
    }

    @Override
    public void close() {
        if (!ObjectUtils.isEmpty((Object)this.closeThread.get())) {
            Runtime.getRuntime().removeShutdownHook(this.closeThread.get());
        }
        if (this.isStarted.get()) {
            this.isStarted.set(false);
            try {
                this.close0();
            }
            catch (Exception e) {
                LOG.error("{} close error.", (Object)this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void consume(List<L> logs) throws Exception {
        if (CollectionUtils.isEmpty(logs) || !this.isStarted.get()) {
            return;
        }
        this.consume0(logs);
    }
}

