/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.constant.Constants;

public class ShenyuTrieNode
implements Serializable {
    private static final long serialVersionUID = -2347426887850566364L;
    private String matchStr;
    private String fullPath;
    private Map<String, ShenyuTrieNode> children;
    private Map<String, ShenyuTrieNode> pathVariables;
    private ShenyuTrieNode pathVariableNode;
    private boolean isWildcard;
    private boolean endOfPath;
    private Map<String, List<?>> pathCache;
    private String bizInfo;
    private ShenyuTrieNode parentNode;
    private ShenyuTrieNode failToNode;

    public ShenyuTrieNode() {
    }

    public ShenyuTrieNode(String matchStr, String fullPath, boolean endOfPath) {
        this.matchStr = matchStr;
        this.fullPath = fullPath;
        this.endOfPath = endOfPath;
        this.children = new ConcurrentHashMap<String, ShenyuTrieNode>(Constants.TRIE_CHILDREN_SIZE);
        this.pathCache = new ConcurrentHashMap(Constants.TRIE_PATH_CACHE_SIZE);
        this.pathVariables = new ConcurrentHashMap<String, ShenyuTrieNode>(Constants.TRIE_PATH_VARIABLES_SIZE);
        this.parentNode = null;
        this.failToNode = null;
    }

    public String getMatchStr() {
        return this.matchStr;
    }

    public void setMatchStr(String matchStr) {
        this.matchStr = matchStr;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Map<String, ShenyuTrieNode> getChildren() {
        return this.children;
    }

    public Map<String, ShenyuTrieNode> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, ShenyuTrieNode> pathVariablesSet) {
        this.pathVariables = pathVariablesSet;
    }

    public ShenyuTrieNode getPathVariableNode() {
        return this.pathVariableNode;
    }

    public void setPathVariableNode(ShenyuTrieNode pathVariableNode) {
        this.pathVariableNode = pathVariableNode;
    }

    public void setChildren(Map<String, ShenyuTrieNode> children) {
        this.children = children;
    }

    public boolean getWildcard() {
        return this.isWildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.isWildcard = wildcard;
    }

    public boolean getEndOfPath() {
        return this.endOfPath;
    }

    public void setEndOfPath(boolean endOfPath) {
        this.endOfPath = endOfPath;
    }

    public String getBizInfo() {
        return this.bizInfo;
    }

    public void setBizInfo(String bizInfo) {
        this.bizInfo = bizInfo;
    }

    public Map<String, List<?>> getPathCache() {
        return this.pathCache;
    }

    public void setPathRuleCache(Map<String, List<?>> pathCache) {
        this.pathCache = pathCache;
    }

    public ShenyuTrieNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(ShenyuTrieNode parentNode) {
        this.parentNode = parentNode;
    }

    public ShenyuTrieNode getFailToNode() {
        return this.failToNode;
    }

    public void setFailToNode(ShenyuTrieNode failToNode) {
        this.failToNode = failToNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShenyuTrieNode)) {
            return false;
        }
        ShenyuTrieNode that = (ShenyuTrieNode)o;
        return this.getWildcard() == that.getWildcard() && this.getEndOfPath() == that.getEndOfPath() && Objects.equals(this.getMatchStr(), that.getMatchStr()) && Objects.equals(this.getFullPath(), that.getFullPath()) && Objects.equals(this.getChildren(), that.getChildren()) && Objects.equals(this.getPathVariables(), that.getPathVariables()) && Objects.equals(this.getPathVariableNode(), that.getPathVariableNode()) && Objects.equals(this.getPathCache(), that.getPathCache()) && Objects.equals(this.getBizInfo(), that.getBizInfo()) && Objects.equals(this.getParentNode(), that.getParentNode()) && Objects.equals(this.getFailToNode(), that.getFailToNode());
    }

    public int hashCode() {
        return Objects.hash(this.getMatchStr(), this.getFullPath(), this.getChildren(), this.getPathVariables(), this.getPathVariableNode(), this.getWildcard(), this.getEndOfPath(), this.getPathCache(), this.getBizInfo(), this.getParentNode(), this.getFailToNode());
    }

    public String toString() {
        return "ShenyuTrieNode{matchStr='" + this.matchStr + ", fullPath='" + this.fullPath + ", children=" + this.children + ", pathVariables=" + this.pathVariables + ", pathVariableNode=" + this.pathVariableNode + ", isWildcard=" + this.isWildcard + ", endOfPath=" + this.endOfPath + ", pathCache=" + this.pathCache + ", bizInfo='" + this.bizInfo + "}";
    }
}

