/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.handler;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.AiProxyHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class AiProxyPluginHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, AiProxyHandle>> SELECTOR_CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            AiCommonConfig aiCommonConfig = (AiCommonConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), AiCommonConfig.class);
            if (Objects.isNull(aiCommonConfig)) {
                return;
            }
            Singleton.INST.single(AiCommonConfig.class, (Object)aiCommonConfig);
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        if (Objects.isNull(selectorData.getHandle())) {
            return;
        }
        AiProxyHandle aiProxyHandle = (AiProxyHandle)GsonUtils.getInstance().fromJson(selectorData.getHandle(), AiProxyHandle.class);
        SELECTOR_CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)aiProxyHandle);
    }

    public void removeSelector(SelectorData selectorData) {
        SELECTOR_CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public String pluginNamed() {
        return PluginEnum.AI_PROXY.getName();
    }
}

