/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseRenameMethod;
import com.clickhouse.client.data.ClickHouseSimpleRecord;
import com.clickhouse.client.data.ClickHouseStringValue;
import com.clickhouse.client.data.tsv.ByteFragment;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ClickHouseTabSeparatedProcessor
extends ClickHouseDataProcessor {
    private static final Map<ClickHouseFormat, MappedFunctions> cachedFuncs = new EnumMap<ClickHouseFormat, MappedFunctions>(ClickHouseFormat.class);
    private TextHandler textHandler;
    private ByteFragment currentRow;

    private static TextHandler getTextHandler(ClickHouseFormat format) {
        TextHandler textHandler;
        switch (format) {
            case CSV: 
            case CSVWithNames: {
                textHandler = new TextHandler(',', '\t', '\\');
                break;
            }
            case TSV: 
            case TSVRaw: 
            case TSVWithNames: 
            case TSVWithNamesAndTypes: 
            case TabSeparated: 
            case TabSeparatedRaw: 
            case TabSeparatedWithNames: 
            case TabSeparatedWithNamesAndTypes: {
                textHandler = new TextHandler('\t', '\n', '\\');
                break;
            }
            default: {
                textHandler = new TextHandler('\n');
            }
        }
        return textHandler;
    }

    private static String[] toStringArray(ByteFragment headerFragment, byte delimitter) {
        if (delimitter == 0) {
            return new String[]{headerFragment.asString(true)};
        }
        ByteFragment[] split = headerFragment.split(delimitter);
        String[] array = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = split[i].asString(true);
        }
        return array;
    }

    public static MappedFunctions getMappedFunctions(ClickHouseFormat format) {
        return cachedFuncs.computeIfAbsent(format, x$0 -> new MappedFunctions((ClickHouseFormat)((Object)x$0)));
    }

    protected TextHandler getTextHandler() {
        if (this.textHandler == null) {
            this.textHandler = ClickHouseTabSeparatedProcessor.getTextHandler(this.config.getFormat());
        }
        return this.textHandler;
    }

    @Override
    protected ClickHouseRecord createRecord() {
        return new ClickHouseSimpleRecord(this.getColumns(), this.templates);
    }

    @Override
    protected void readAndFill(ClickHouseRecord r) throws IOException {
        ClickHouseByteBuffer buf = this.input.readCustom(this.getTextHandler()::readLine);
        if (buf.isEmpty() && this.input.available() < 1) {
            throw new EOFException();
        }
        this.currentRow = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.getTextHandler().rowDelimiter ? buf.length() - 1 : buf.length());
        int index = this.readPosition;
        byte delimiter = this.getTextHandler().colDelimiter;
        ByteFragment[] currentCols = this.columns.length > 1 && delimiter != 0 ? this.currentRow.split(delimiter) : new ByteFragment[]{this.currentRow};
        while (this.readPosition < this.columns.length) {
            r.getValue(this.readPosition).update(currentCols[this.readPosition - index].asString(true));
            ++this.readPosition;
        }
    }

    @Override
    protected void readAndFill(ClickHouseValue value, ClickHouseColumn column) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<ClickHouseColumn> readColumns() throws IOException {
        String[] types;
        String[] cols;
        block10: {
            ClickHouseByteBuffer buf;
            block9: {
                if (this.input == null) {
                    return Collections.emptyList();
                }
                ClickHouseFormat format = this.config.getFormat();
                if (!format.hasHeader()) {
                    return DEFAULT_COLUMNS;
                }
                buf = this.input.readCustom(this.getTextHandler()::readLine);
                if (buf.isEmpty()) {
                    this.input.close();
                    return Collections.emptyList();
                }
                ByteFragment headerFragment = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.getTextHandler().rowDelimiter ? buf.length() - 1 : buf.length());
                String header = headerFragment.asString(true);
                if (header.startsWith("Code: ") && !header.contains("\t")) {
                    this.input.close();
                    throw new IllegalArgumentException("ClickHouse error: " + header);
                }
                cols = ClickHouseTabSeparatedProcessor.toStringArray(headerFragment, this.getTextHandler().colDelimiter);
                types = null;
                if (ClickHouseFormat.TSVWithNamesAndTypes == format) break block9;
                if (ClickHouseFormat.TabSeparatedWithNamesAndTypes != format) break block10;
            }
            if ((buf = this.input.readCustom(this.getTextHandler()::readLine)).isEmpty()) {
                this.input.close();
                throw new IllegalArgumentException("ClickHouse response without column types");
            }
            ByteFragment typesFragment = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.getTextHandler().rowDelimiter ? buf.length() - 1 : buf.length());
            types = ClickHouseTabSeparatedProcessor.toStringArray(typesFragment, this.getTextHandler().colDelimiter);
        }
        ClickHouseRenameMethod m = (ClickHouseRenameMethod)((Object)this.config.getOption(ClickHouseClientOption.RENAME_RESPONSE_COLUMN));
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            list.add(ClickHouseColumn.of(m.rename(cols[i]), (String)(types == null ? "Nullable(String)" : types[i])));
        }
        return list;
    }

    public ClickHouseTabSeparatedProcessor(ClickHouseConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, List<ClickHouseColumn> columns, Map<String, Object> settings) throws IOException {
        super(config, input, output, columns, settings);
    }

    @Override
    public void write(ClickHouseValue value, ClickHouseColumn column) throws IOException {
        if (this.output == null || column == null) {
            throw new IllegalArgumentException("Cannot write any value when output stream or column is null");
        }
        this.output.writeBytes(value.isNullOrEmpty() ? TextHandler.NULL : value.asBinary());
        this.output.writeCustom(column.isLastColumn() ? this.getTextHandler()::writeLine : this.getTextHandler()::writeColumn);
    }

    public static final class MappedFunctions
    implements ClickHouseDeserializer<ClickHouseValue>,
    ClickHouseSerializer<ClickHouseValue> {
        private final TextHandler textHandler;

        private MappedFunctions(ClickHouseFormat format) {
            this.textHandler = ClickHouseTabSeparatedProcessor.getTextHandler(format);
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseConfig config, ClickHouseColumn column, ClickHouseInputStream input) throws IOException {
            if (ref == null) {
                ref = ClickHouseStringValue.ofNull();
            }
            return ref.update(input.readCustom(column.isLastColumn() && column.isFirstColumn() ? this.textHandler::readLine : this.textHandler::readColumn).asUnicodeString());
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseConfig config, ClickHouseColumn column, ClickHouseOutputStream output) throws IOException {
            output.writeBytes(value.isNullOrEmpty() ? TextHandler.NULL : value.asBinary());
            output.writeCustom(column.isLastColumn() ? this.textHandler::writeLine : this.textHandler::writeColumn);
        }
    }

    static final class TextHandler {
        static final byte[] NULL = "\\N".getBytes(StandardCharsets.US_ASCII);
        private final byte colDelimiter;
        private final byte rowDelimiter;
        private final byte escapeByte;
        private byte prev;

        TextHandler(char rowDelimiter) {
            this.colDelimiter = 0;
            this.rowDelimiter = (byte)rowDelimiter;
            this.escapeByte = 0;
            this.prev = 0;
        }

        TextHandler(char colDelimiter, char rowDelimiter, char escapeByte) {
            this.colDelimiter = (byte)colDelimiter;
            this.rowDelimiter = (byte)rowDelimiter;
            this.escapeByte = (byte)escapeByte;
            this.prev = 0;
        }

        private int read(byte[] bytes, int position, int limit) {
            int offset = 0;
            for (int i = position; i < limit; ++i) {
                byte b = bytes[i];
                ++offset;
                if (b != this.rowDelimiter) continue;
                return offset;
            }
            return -1;
        }

        int readLine(byte[] bytes, int position, int limit) {
            if (this.escapeByte == 0) {
                return this.read(bytes, position, limit);
            }
            int offset = 0;
            for (int i = position; i < limit; ++i) {
                byte b = bytes[i];
                ++offset;
                if (this.prev == this.escapeByte) {
                    this.prev = b == this.escapeByte ? (byte)0 : b;
                    continue;
                }
                this.prev = b;
                if (b != this.rowDelimiter) continue;
                return offset;
            }
            return -1;
        }

        int readColumn(byte[] bytes, int position, int limit) {
            if (this.colDelimiter == 0) {
                return this.readLine(bytes, position, limit);
            }
            int offset = 0;
            for (int i = position; i < limit; ++i) {
                byte b = bytes[i];
                ++offset;
                if (this.prev == this.escapeByte) {
                    this.prev = b == this.escapeByte ? (byte)0 : b;
                    continue;
                }
                this.prev = b;
                if (b != this.colDelimiter && b != this.rowDelimiter) continue;
                return offset;
            }
            return -1;
        }

        int writeColumn(byte[] bytes, int position, int limit) {
            if (this.colDelimiter == 0) {
                return this.writeLine(bytes, position, limit);
            }
            bytes[position] = this.colDelimiter;
            return 1;
        }

        int writeLine(byte[] bytes, int position, int limit) {
            if (this.rowDelimiter == 0) {
                return 0;
            }
            bytes[position] = this.rowDelimiter;
            return 1;
        }
    }
}

