/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.util.Arrays;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.proxy.AbstractProxyFactory;
import org.apache.dubbo.rpc.proxy.jdk.JdkProxyFactory;

public abstract class AbstractFallbackJdkProxyFactory
extends AbstractProxyFactory {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final JdkProxyFactory jdkProxyFactory = new JdkProxyFactory();

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) throws RpcException {
        try {
            return this.doGetInvoker(proxy, type, url);
        }
        catch (Throwable throwable) {
            String factoryName = this.getClass().getSimpleName();
            try {
                Invoker<T> invoker = this.jdkProxyFactory.getInvoker(proxy, type, url);
                this.logger.error("3-8", "", "", "Failed to generate invoker by " + factoryName + " failed. Fallback to use JDK proxy success. Interfaces: " + type, throwable);
                return invoker;
            }
            catch (Throwable fromJdk) {
                this.logger.error("3-8", "", "", "Failed to generate invoker by " + factoryName + " failed. Fallback to use JDK proxy is also failed. Interfaces: " + type + " Javassist Error.", throwable);
                this.logger.error("3-8", "", "", "Failed to generate invoker by " + factoryName + " failed. Fallback to use JDK proxy is also failed. Interfaces: " + type + " JDK Error.", fromJdk);
                throw throwable;
            }
        }
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, Class<?>[] interfaces) {
        try {
            return this.doGetProxy(invoker, interfaces);
        }
        catch (Throwable throwable) {
            String factoryName = this.getClass().getSimpleName();
            try {
                T proxy = this.jdkProxyFactory.getProxy(invoker, interfaces);
                this.logger.error("3-8", "", "", "Failed to generate proxy by " + factoryName + " failed. Fallback to use JDK proxy success. Interfaces: " + Arrays.toString(interfaces), throwable);
                return proxy;
            }
            catch (Throwable fromJdk) {
                this.logger.error("3-8", "", "", "Failed to generate proxy by " + factoryName + " failed. Fallback to use JDK proxy is also failed. Interfaces: " + Arrays.toString(interfaces) + " Javassist Error.", throwable);
                this.logger.error("3-8", "", "", "Failed to generate proxy by " + factoryName + " failed. Fallback to use JDK proxy is also failed. Interfaces: " + Arrays.toString(interfaces) + " JDK Error.", fromJdk);
                throw throwable;
            }
        }
    }

    protected abstract <T> Invoker<T> doGetInvoker(T var1, Class<T> var2, URL var3);

    protected abstract <T> T doGetProxy(Invoker<T> var1, Class<?>[] var2);
}

