/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectUtils {
    public static Class findClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        return ReflectUtils.findClass(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Class findClassAndTryCatch(String name, ClassLoader classLoader) {
        try {
            return ReflectUtils.findClass(name, classLoader);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Class findClass(ClassLoader classLoader, String ... name) throws ClassNotFoundException {
        String[] names;
        for (String s : names = name) {
            Class tmp = ReflectUtils.findClassAndTryCatch(s, classLoader);
            if (tmp == null) continue;
            return tmp;
        }
        throw new ClassNotFoundException();
    }

    public static Class findClassTryException(ClassLoader classLoader, String ... name) {
        try {
            return ReflectUtils.findClass(classLoader, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Method> getMethodByNameList(Class clazz, String name) {
        return ReflectUtils.getMethodByNameList(clazz, name, false);
    }

    public static List<Method> getMethodByNameList(Class clazz, String name, boolean declare) {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            ReflectUtils.filterMethod(name, methods, clazz.getDeclaredMethods());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!declare) {
            return new ArrayList<Method>(methods);
        }
        try {
            ReflectUtils.filterMethod(name, methods, clazz.getMethods());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Method>(methods);
    }

    public static List<Constructor<?>> getConstructList(Class clazz) {
        HashSet methods = new HashSet();
        try {
            ReflectUtils.filterConstructMethod(methods, clazz.getDeclaredConstructors());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ReflectUtils.filterConstructMethod(methods, clazz.getConstructors());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList(methods);
    }

    private static void filterConstructMethod(Set<Constructor<?>> methods, Constructor<?>[] declaredMethods) {
        for (Constructor<?> constructor : declaredMethods) {
            methods.add(constructor);
        }
    }

    private static void filterMethod(String name, Set<Method> methodList, Method[] methods) {
        for (Method declaredMethod : methods) {
            if (!name.equals(declaredMethod.getName())) continue;
            declaredMethod.setAccessible(true);
            methodList.add(declaredMethod);
        }
    }

    public static Method getMethodByName(Class clazz, String name) {
        List<Method> methodByNameList = ReflectUtils.getMethodByNameList(clazz, name, true);
        if (methodByNameList.isEmpty()) {
            return null;
        }
        return methodByNameList.get(0);
    }

    public static Class findClassTryException(String ... name) {
        return ReflectUtils.findClassTryException(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Object invoke(Object object, Method method, Object[] params) throws InvocationTargetException, IllegalAccessException {
        return method.invoke(object, params);
    }

    public static Object invokeAndTryCatch(Object object, Method method, Object[] params) {
        try {
            return ReflectUtils.invoke(object, method, params);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

