/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.executor.AbstractIsolationExecutorSupport;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.protocol.dubbo.DecodeableRpcInvocation;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

public class DubboIsolationExecutorSupport
extends AbstractIsolationExecutorSupport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboIsolationExecutorSupport.class);
    private final FrameworkServiceRepository frameworkServiceRepository;
    private final DubboProtocol dubboProtocol;

    public DubboIsolationExecutorSupport(URL url) {
        super(url);
        this.frameworkServiceRepository = url.getOrDefaultFrameworkModel().getServiceRepository();
        this.dubboProtocol = DubboProtocol.getDubboProtocol(url.getOrDefaultFrameworkModel());
    }

    @Override
    protected ProviderModel getProviderModel(Object data) {
        if (!(data instanceof Request)) {
            return null;
        }
        Request request = (Request)data;
        if (!(request.getData() instanceof DecodeableRpcInvocation)) {
            return null;
        }
        try {
            ((DecodeableRpcInvocation)request.getData()).fillInvoker(this.dubboProtocol);
        }
        catch (RemotingException remotingException) {
            // empty catch block
        }
        ServiceModel serviceModel = ((Invocation)request.getData()).getServiceModel();
        if (serviceModel instanceof ProviderModel) {
            return (ProviderModel)serviceModel;
        }
        String targetServiceUniqueName = ((Invocation)request.getData()).getTargetServiceUniqueName();
        if (StringUtils.isNotEmpty(targetServiceUniqueName)) {
            return this.frameworkServiceRepository.lookupExportedService(targetServiceUniqueName);
        }
        return null;
    }
}

