/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.config;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.condition.config.ListenableStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class ProviderAppStateRouter<T>
extends ListenableStateRouter<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ListenableStateRouter.class);
    public static final String NAME = "PROVIDER_APP_ROUTER";
    private String application;
    private final String currentApplication;

    public ProviderAppStateRouter(URL url) {
        super(url, url.getApplication());
        this.currentApplication = url.getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        if (CollectionUtils.isEmpty(invokers)) {
            return;
        }
        Invoker<T> invoker = invokers.get(0);
        URL url = invoker.getUrl();
        String providerApplication = url.getRemoteApplication();
        if (StringUtils.isEmpty(providerApplication)) {
            logger.warn("2-12", "condition router get providerApplication is empty, will not subscribe to provider app rules.", "", "");
            return;
        }
        if (providerApplication.equals(this.currentApplication)) {
            return;
        }
        ProviderAppStateRouter providerAppStateRouter = this;
        synchronized (providerAppStateRouter) {
            if (!providerApplication.equals(this.application)) {
                if (StringUtils.isNotEmpty(this.application)) {
                    this.getRuleRepository().removeListener(this.application + ".condition-router", this);
                }
                String key = providerApplication + ".condition-router";
                this.getRuleRepository().addListener(key, this);
                this.application = providerApplication;
                String rawRule = this.getRuleRepository().getRule(key, "dubbo");
                if (StringUtils.isNotEmpty(rawRule)) {
                    this.process(new ConfigChangedEvent(key, "dubbo", rawRule));
                }
            }
        }
    }
}

