/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.restclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.RestResult;
import org.apache.dubbo.remoting.http.config.HttpClientConfig;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientRestClient
implements RestClient {
    private final CloseableHttpClient closeableHttpClient = this.createHttpClient();
    private final HttpClientConfig httpClientConfig;

    public HttpClientRestClient(HttpClientConfig clientConfig) {
        this.httpClientConfig = clientConfig;
    }

    @Override
    public CompletableFuture<RestResult> send(RequestTemplate requestTemplate) {
        HttpRequestBase httpRequest = null;
        String httpMethod = requestTemplate.getHttpMethod();
        httpRequest = this.createHttpUriRequest(httpMethod, requestTemplate);
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)new ByteArrayEntity(requestTemplate.getSerializedBody()));
        }
        Map<String, Collection<String>> allHeaders = requestTemplate.getAllHeaders();
        allHeaders.remove("Content-Length");
        for (String headerName : allHeaders.keySet()) {
            Collection<String> headerValues = allHeaders.get(headerName);
            for (String headerValue : headerValues) {
                httpRequest.addHeader(headerName, headerValue);
            }
        }
        httpRequest.setConfig(this.getRequestConfig(this.httpClientConfig));
        CompletableFuture<RestResult> future = new CompletableFuture<RestResult>();
        try {
            final CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)httpRequest);
            future.complete(new RestResult(){

                @Override
                public String getContentType() {
                    Header header = response.getFirstHeader("Content-Type");
                    return header == null ? null : header.getValue();
                }

                @Override
                public byte[] getBody() throws IOException {
                    if (response.getEntity() == null) {
                        return new byte[0];
                    }
                    return IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                }

                @Override
                public Map<String, List<String>> headers() {
                    return Arrays.stream(response.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, h -> Collections.singletonList(h.getValue())));
                }

                @Override
                public byte[] getErrorResponse() throws IOException {
                    return this.getBody();
                }

                @Override
                public int getResponseCode() {
                    return response.getStatusLine().getStatusCode();
                }

                @Override
                public String getMessage() throws IOException {
                    return this.appendErrorMessage(response.getStatusLine().getReasonPhrase(), new String(this.getErrorResponse()));
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private RequestConfig getRequestConfig(HttpClientConfig clientConfig) {
        return RequestConfig.custom().build();
    }

    @Override
    public void close() {
        try {
            this.closeableHttpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close(int timeout) {
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    public CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    protected HttpRequestBase createHttpUriRequest(String httpMethod, RequestTemplate requestTemplate) {
        String uri = requestTemplate.getURL();
        HttpGet httpUriRequest = null;
        if ("GET".equals(httpMethod)) {
            httpUriRequest = new HttpGet(uri);
        } else if ("HEAD".equals(httpMethod)) {
            httpUriRequest = new HttpHead(uri);
        } else if ("POST".equals(httpMethod)) {
            httpUriRequest = new HttpPost(uri);
        } else if ("PUT".equals(httpMethod)) {
            httpUriRequest = new HttpPut(uri);
        } else if ("PATCH".equals(httpMethod)) {
            httpUriRequest = new HttpPatch(uri);
        } else if ("DELETE".equals(httpMethod)) {
            httpUriRequest = new HttpDelete(uri);
        } else if ("OPTIONS".equals(httpMethod)) {
            httpUriRequest = new HttpOptions(uri);
        } else if ("TRACE".equals(httpMethod)) {
            httpUriRequest = new HttpTrace(uri);
        } else {
            throw new IllegalArgumentException("Invalid HTTP method: " + httpMethod);
        }
        return httpUriRequest;
    }
}

