/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.Map;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractBuilder;

public class ConfigCenterBuilder
extends AbstractBuilder<ConfigCenterConfig, ConfigCenterBuilder> {
    private String protocol;
    private String address;
    private String cluster;
    private String namespace = "dubbo";
    private String group = "dubbo";
    private String username;
    private String password;
    private Long timeout = 3000L;
    private Boolean highestPriority = true;
    private Boolean check = true;
    private String configFile = "dubbo.properties";
    private String appConfigFile;
    private Map<String, String> parameters;

    public static ConfigCenterBuilder newBuilder() {
        return new ConfigCenterBuilder();
    }

    public ConfigCenterBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this.getThis();
    }

    public ConfigCenterBuilder address(String address) {
        this.address = address;
        return this.getThis();
    }

    public ConfigCenterBuilder cluster(String cluster) {
        this.cluster = cluster;
        return this.getThis();
    }

    public ConfigCenterBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this.getThis();
    }

    public ConfigCenterBuilder group(String group) {
        this.group = group;
        return this.getThis();
    }

    public ConfigCenterBuilder username(String username) {
        this.username = username;
        return this.getThis();
    }

    public ConfigCenterBuilder password(String password) {
        this.password = password;
        return this.getThis();
    }

    public ConfigCenterBuilder timeout(Long timeout) {
        this.timeout = timeout;
        return this.getThis();
    }

    public ConfigCenterBuilder highestPriority(Boolean highestPriority) {
        this.highestPriority = highestPriority;
        return this.getThis();
    }

    public ConfigCenterBuilder check(Boolean check) {
        this.check = check;
        return this.getThis();
    }

    public ConfigCenterBuilder configFile(String configFile) {
        this.configFile = configFile;
        return this.getThis();
    }

    public ConfigCenterBuilder appConfigFile(String appConfigFile) {
        this.appConfigFile = appConfigFile;
        return this.getThis();
    }

    public ConfigCenterBuilder appendParameters(Map<String, String> appendParameters) {
        this.parameters = ConfigCenterBuilder.appendParameters(this.parameters, appendParameters);
        return this.getThis();
    }

    public ConfigCenterBuilder appendParameter(String key, String value) {
        this.parameters = ConfigCenterBuilder.appendParameter(this.parameters, key, value);
        return this.getThis();
    }

    @Override
    public ConfigCenterConfig build() {
        ConfigCenterConfig configCenter = new ConfigCenterConfig();
        super.build(configCenter);
        configCenter.setProtocol(this.protocol);
        configCenter.setAddress(this.address);
        configCenter.setCluster(this.cluster);
        configCenter.setNamespace(this.namespace);
        configCenter.setGroup(this.group);
        configCenter.setUsername(this.username);
        configCenter.setPassword(this.password);
        configCenter.setTimeout(this.timeout);
        configCenter.setHighestPriority(this.highestPriority);
        configCenter.setCheck(this.check);
        configCenter.setConfigFile(this.configFile);
        configCenter.setAppConfigFile(this.appConfigFile);
        configCenter.setParameters(this.parameters);
        return configCenter;
    }

    @Override
    protected ConfigCenterBuilder getThis() {
        return this;
    }
}

