/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.common.model;

import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.common.model.AbstractSignatureStatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategy;
import com.tencent.polaris.plugins.stat.common.model.StatMetric;
import com.tencent.polaris.plugins.stat.common.model.StatStatefulMetric;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class StatInfoStatefulCollector<T>
extends AbstractSignatureStatInfoCollector<T, StatStatefulMetric> {
    private static final Logger LOG = LoggerFactory.getLogger(StatInfoStatefulCollector.class);
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectStatInfo(T info, Map<String, String> metricLabels, MetricValueAggregationStrategy<T>[] strategies) {
        if (null != strategies) {
            for (MetricValueAggregationStrategy<T> strategy : strategies) {
                HashMap<String, String> labels;
                String metricName = strategy.getStrategyName();
                Long signature = StatInfoStatefulCollector.getSignature(metricName, labels = new HashMap<String, String>(metricLabels));
                StatMetric metric = (StatMetric)this.metricContainer.get(signature);
                if (null == metric) {
                    Object object = this.mutex;
                    synchronized (object) {
                        metric = (StatMetric)this.metricContainer.get(signature);
                        if (null == metric) {
                            StatStatefulMetric statMetric = new StatStatefulMetric(metricName, labels, signature);
                            statMetric.setValue((long)strategy.initMetricValue(info));
                            LOG.debug("{} with signature {} init value is {}", new Object[]{strategy.getStrategyName(), signature, statMetric.getValue()});
                            this.metricContainer.put(signature, statMetric);
                            continue;
                        }
                    }
                }
                strategy.updateMetricValue(metric, info);
                LOG.debug("{} with signature {} update value is {}", new Object[]{strategy.getStrategyName(), signature, metric.getValue()});
            }
        }
    }
}

