/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import org.apache.pulsar.client.admin.utils.ReflectionUtils;

public interface ClusterPolicies {
    public boolean isMigrated();

    public ClusterUrl getMigratedClusterUrl();

    public Builder clone();

    public static Builder builder() {
        return (Builder)ReflectionUtils.newBuilder("org.apache.pulsar.common.policies.data.ClusterPoliciesImpl");
    }

    public static interface Builder {
        public Builder migrated(boolean var1);

        public Builder migratedClusterUrl(ClusterUrl var1);

        public ClusterPolicies build();
    }

    public static class ClusterUrl {
        String serviceUrl;
        String serviceUrlTls;
        String brokerServiceUrl;
        String brokerServiceUrlTls;

        public boolean isEmpty() {
            return this.serviceUrl != null && this.serviceUrlTls != null && this.brokerServiceUrl == null && this.brokerServiceUrlTls == null;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public String getServiceUrlTls() {
            return this.serviceUrlTls;
        }

        public String getBrokerServiceUrl() {
            return this.brokerServiceUrl;
        }

        public String getBrokerServiceUrlTls() {
            return this.brokerServiceUrlTls;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public void setServiceUrlTls(String serviceUrlTls) {
            this.serviceUrlTls = serviceUrlTls;
        }

        public void setBrokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
        }

        public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
        }

        public String toString() {
            return "ClusterPolicies.ClusterUrl(serviceUrl=" + this.getServiceUrl() + ", serviceUrlTls=" + this.getServiceUrlTls() + ", brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ")";
        }

        public ClusterUrl() {
        }

        public ClusterUrl(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls) {
            this.serviceUrl = serviceUrl;
            this.serviceUrlTls = serviceUrlTls;
            this.brokerServiceUrl = brokerServiceUrl;
            this.brokerServiceUrlTls = brokerServiceUrlTls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterUrl)) {
                return false;
            }
            ClusterUrl other = (ClusterUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceUrl = this.getServiceUrl();
            String other$serviceUrl = other.getServiceUrl();
            if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
                return false;
            }
            String this$serviceUrlTls = this.getServiceUrlTls();
            String other$serviceUrlTls = other.getServiceUrlTls();
            if (this$serviceUrlTls == null ? other$serviceUrlTls != null : !this$serviceUrlTls.equals(other$serviceUrlTls)) {
                return false;
            }
            String this$brokerServiceUrl = this.getBrokerServiceUrl();
            String other$brokerServiceUrl = other.getBrokerServiceUrl();
            if (this$brokerServiceUrl == null ? other$brokerServiceUrl != null : !this$brokerServiceUrl.equals(other$brokerServiceUrl)) {
                return false;
            }
            String this$brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            String other$brokerServiceUrlTls = other.getBrokerServiceUrlTls();
            return !(this$brokerServiceUrlTls == null ? other$brokerServiceUrlTls != null : !this$brokerServiceUrlTls.equals(other$brokerServiceUrlTls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterUrl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceUrl = this.getServiceUrl();
            result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
            String $serviceUrlTls = this.getServiceUrlTls();
            result = result * 59 + ($serviceUrlTls == null ? 43 : $serviceUrlTls.hashCode());
            String $brokerServiceUrl = this.getBrokerServiceUrl();
            result = result * 59 + ($brokerServiceUrl == null ? 43 : $brokerServiceUrl.hashCode());
            String $brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            result = result * 59 + ($brokerServiceUrlTls == null ? 43 : $brokerServiceUrlTls.hashCode());
            return result;
        }
    }
}

