/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.BufferObject;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.serializer.StringSerializer;
import io.fury.type.Type;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;

public class ArraySerializers {
    static final IdentityHashMap<Class<?>, int[]> primitiveInfo = new IdentityHashMap();

    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Object[].class, new ObjectArraySerializer(fury, (Class<T[]>)Object[].class));
        fury.registerSerializer(byte[].class, new ByteArraySerializer(fury));
        fury.registerSerializer(char[].class, new CharArraySerializer(fury));
        fury.registerSerializer(short[].class, new ShortArraySerializer(fury));
        fury.registerSerializer(int[].class, new IntArraySerializer(fury));
        fury.registerSerializer(long[].class, new LongArraySerializer(fury));
        fury.registerSerializer(float[].class, new FloatArraySerializer(fury));
        fury.registerSerializer(double[].class, new DoubleArraySerializer(fury));
        fury.registerSerializer(boolean[].class, new BooleanArraySerializer(fury));
        fury.registerSerializer(String[].class, new StringArraySerializer(fury));
    }

    static void writePrimitiveArray(MemoryBuffer buffer, Object arr, int offset, int numElements, int elemSize) {
        int size = Math.multiplyExact(numElements, elemSize);
        buffer.writePositiveVarInt(size);
        int writerIndex = buffer.writerIndex();
        int end = writerIndex + size;
        buffer.ensure(end);
        buffer.copyFromUnsafe(writerIndex, arr, offset, size);
        buffer.writerIndex(end);
    }

    public static PrimitiveArrayBufferObject byteArrayBufferObject(byte[] array) {
        return new PrimitiveArrayBufferObject(array, Platform.BYTE_ARRAY_OFFSET, 1, array.length);
    }

    static {
        primitiveInfo.put(Boolean.TYPE, new int[]{Platform.BOOLEAN_ARRAY_OFFSET, 1, Type.FURY_PRIMITIVE_BOOL_ARRAY.getId()});
        primitiveInfo.put(Byte.TYPE, new int[]{Platform.BYTE_ARRAY_OFFSET, 1, Type.BINARY.getId()});
        primitiveInfo.put(Character.TYPE, new int[]{Platform.CHAR_ARRAY_OFFSET, 2, 0});
        primitiveInfo.put(Short.TYPE, new int[]{Platform.SHORT_ARRAY_OFFSET, 2, Type.FURY_PRIMITIVE_SHORT_ARRAY.getId()});
        primitiveInfo.put(Integer.TYPE, new int[]{Platform.INT_ARRAY_OFFSET, 4, Type.FURY_PRIMITIVE_INT_ARRAY.getId()});
        primitiveInfo.put(Long.TYPE, new int[]{Platform.LONG_ARRAY_OFFSET, 8, Type.FURY_PRIMITIVE_LONG_ARRAY.getId()});
        primitiveInfo.put(Float.TYPE, new int[]{Platform.FLOAT_ARRAY_OFFSET, 4, Type.FURY_PRIMITIVE_FLOAT_ARRAY.getId()});
        primitiveInfo.put(Double.TYPE, new int[]{Platform.DOUBLE_ARRAY_OFFSET, 8, Type.FURY_PRIMITIVE_DOUBLE_ARRAY.getId()});
    }

    public static final class ObjectArraySerializer<T>
    extends Serializer<T[]> {
        private final Class<T> innerType;
        private final Serializer componentTypeSerializer;
        private final ClassInfoHolder classInfoHolder;
        private final int dimension;
        private final int[] stubDims;

        public ObjectArraySerializer(Fury fury, Class<T[]> cls) {
            super(fury, cls);
            Preconditions.checkArgument(cls.isArray());
            Class<Object> t = cls;
            Class<T[]> innerType = cls;
            int dimension = 0;
            while (t != null && t.isArray()) {
                ++dimension;
                if ((t = t.getComponentType()) == null) continue;
                innerType = t;
            }
            this.dimension = dimension;
            this.innerType = innerType;
            Class<?> componentType = cls.getComponentType();
            this.componentTypeSerializer = Modifier.isFinal(componentType.getModifiers()) ? fury.getClassResolver().getSerializer(componentType) : null;
            this.stubDims = new int[dimension];
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, T[] arr) {
            int len = arr.length;
            buffer.writeInt(len);
            RefResolver refResolver = this.fury.getRefResolver();
            Serializer componentSerializer = this.componentTypeSerializer;
            if (componentSerializer != null) {
                for (T t : arr) {
                    if (refResolver.writeRefOrNull(buffer, t)) continue;
                    componentSerializer.write(buffer, t);
                }
            } else {
                Fury fury = this.fury;
                ClassResolver classResolver = fury.getClassResolver();
                ClassInfo classInfo = null;
                Class<?> elemClass = null;
                for (T t : arr) {
                    if (refResolver.writeRefOrNull(buffer, t)) continue;
                    Class<?> clz = t.getClass();
                    if (clz != elemClass) {
                        elemClass = clz;
                        classInfo = classResolver.getClassInfo(clz);
                    }
                    fury.writeNonRef(buffer, t, classInfo);
                }
            }
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T[] arr) {
            int len = arr.length;
            buffer.writePositiveVarInt(len);
            for (T t : arr) {
                this.fury.xwriteRef(buffer, t);
            }
        }

        @Override
        public T[] read(MemoryBuffer buffer) {
            int numElements = buffer.readInt();
            Object[] value = this.newArray(numElements);
            RefResolver refResolver = this.fury.getRefResolver();
            refResolver.reference(value);
            Serializer componentTypeSerializer = this.componentTypeSerializer;
            if (componentTypeSerializer != null) {
                for (int i = 0; i < numElements; ++i) {
                    Object elem;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        elem = componentTypeSerializer.read(buffer);
                        refResolver.setReadObject(nextReadRefId, elem);
                    } else {
                        elem = refResolver.getReadObject();
                    }
                    value[i] = elem;
                }
            } else {
                Fury fury = this.fury;
                ClassInfoHolder classInfoHolder = this.classInfoHolder;
                for (int i = 0; i < numElements; ++i) {
                    Object o;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        o = fury.readNonRef(buffer, classInfoHolder);
                        refResolver.setReadObject(nextReadRefId, o);
                    } else {
                        o = refResolver.getReadObject();
                    }
                    value[i] = o;
                }
            }
            return value;
        }

        @Override
        public T[] xread(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            Object[] value = this.newArray(numElements);
            for (int i = 0; i < numElements; ++i) {
                value[i] = this.fury.xreadRef(buffer);
            }
            return value;
        }

        private Object[] newArray(int numElements) {
            Object[] value;
            if (this.type == Object[].class) {
                value = new Object[numElements];
            } else {
                this.stubDims[0] = numElements;
                value = (Object[])Array.newInstance(this.innerType, this.stubDims);
            }
            return value;
        }
    }

    public static final class ByteArraySerializer
    extends PrimitiveArraySerializer<byte[]> {
        public ByteArraySerializer(Fury fury) {
            super(fury, byte[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, byte[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public byte[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                byte[] values = new byte[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            byte[] values = new byte[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class CharArraySerializer
    extends PrimitiveArraySerializer<char[]> {
        public CharArraySerializer(Fury fury) {
            super(fury, char[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, char[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public char[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                char[] values = new char[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            char[] values = new char[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }

        @Override
        public short getXtypeId() {
            return 0;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, char[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ShortArraySerializer
    extends PrimitiveArraySerializer<short[]> {
        public ShortArraySerializer(Fury fury) {
            super(fury, short[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, short[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public short[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                short[] values = new short[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            short[] values = new short[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class IntArraySerializer
    extends PrimitiveArraySerializer<int[]> {
        public IntArraySerializer(Fury fury) {
            super(fury, int[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, int[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public int[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                int[] values = new int[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            int[] values = new int[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class LongArraySerializer
    extends PrimitiveArraySerializer<long[]> {
        public LongArraySerializer(Fury fury) {
            super(fury, long[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, long[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public long[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                long[] values = new long[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            long[] values = new long[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class FloatArraySerializer
    extends PrimitiveArraySerializer<float[]> {
        public FloatArraySerializer(Fury fury) {
            super(fury, float[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, float[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public float[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                float[] values = new float[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            float[] values = new float[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class DoubleArraySerializer
    extends PrimitiveArraySerializer<double[]> {
        public DoubleArraySerializer(Fury fury) {
            super(fury, double[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, double[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public double[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                double[] values = new double[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            double[] values = new double[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class BooleanArraySerializer
    extends PrimitiveArraySerializer<boolean[]> {
        public BooleanArraySerializer(Fury fury) {
            super(fury, boolean[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, boolean[] value) {
            if (this.fury.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSizeEmbedded(value, this.offset, size);
            } else {
                this.fury.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public boolean[] read(MemoryBuffer buffer) {
            if (this.fury.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fury.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                boolean[] values = new boolean[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readPositiveVarInt();
            int numElements = size / this.elemSize;
            boolean[] values = new boolean[numElements];
            int readerIndex = buffer.readerIndex();
            buffer.copyToUnsafe(readerIndex, values, this.offset, size);
            buffer.readerIndex(readerIndex + size);
            return values;
        }
    }

    public static final class StringArraySerializer
    extends Serializer<String[]> {
        private final StringSerializer stringSerializer;

        public StringArraySerializer(Fury fury) {
            super(fury, String[].class);
            this.stringSerializer = new StringSerializer(fury);
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_STRING_ARRAY.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, String[] value) {
            int len = value.length;
            buffer.writePositiveVarInt(len);
            for (String elem : value) {
                if (elem != null) {
                    buffer.writeByte((byte)0);
                    this.stringSerializer.writeJavaString(buffer, elem);
                    continue;
                }
                buffer.writeByte((byte)-3);
            }
        }

        @Override
        public String[] read(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            String[] value = new String[numElements];
            this.fury.getRefResolver().reference(value);
            for (int i = 0; i < numElements; ++i) {
                value[i] = buffer.readByte() == 0 ? this.stringSerializer.readJavaString(buffer) : null;
            }
            return value;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, String[] value) {
            int len = value.length;
            buffer.writePositiveVarInt(len);
            for (String elem : value) {
                if (elem != null) {
                    buffer.writeByte((byte)0);
                    this.stringSerializer.writeUTF8String(buffer, elem);
                    continue;
                }
                buffer.writeByte((byte)-3);
            }
        }

        @Override
        public String[] xread(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            String[] value = new String[numElements];
            for (int i = 0; i < numElements; ++i) {
                value[i] = buffer.readByte() == 0 ? this.stringSerializer.readUTF8String(buffer) : null;
            }
            return value;
        }
    }

    public static final class PrimitiveArrayBufferObject
    implements BufferObject {
        private final Object array;
        private final int offset;
        private final int elemSize;
        private final int length;

        public PrimitiveArrayBufferObject(Object array, int offset, int elemSize, int length) {
            this.array = array;
            this.offset = offset;
            this.elemSize = elemSize;
            this.length = length;
        }

        @Override
        public int totalBytes() {
            return this.length * this.elemSize;
        }

        @Override
        public void writeTo(MemoryBuffer buffer) {
            int size = Math.multiplyExact(this.length, this.elemSize);
            int writerIndex = buffer.writerIndex();
            int end = writerIndex + size;
            buffer.ensure(end);
            buffer.copyFromUnsafe(writerIndex, this.array, this.offset, size);
            buffer.writerIndex(end);
        }

        @Override
        public MemoryBuffer toBuffer() {
            MemoryBuffer buffer = MemoryBuffer.newHeapBuffer(this.totalBytes());
            this.writeTo(buffer);
            return buffer.slice(0, buffer.writerIndex());
        }
    }

    public static abstract class PrimitiveArraySerializer<T>
    extends Serializers.CrossLanguageCompatibleSerializer<T> {
        protected final int offset;
        protected final int elemSize;

        public PrimitiveArraySerializer(Fury fury, Class<T> cls) {
            super(fury, cls, (short)primitiveInfo.get(TypeUtils.getArrayComponentInfo(cls).f0)[2]);
            Class innerType = (Class)TypeUtils.getArrayComponentInfo(cls).f0;
            this.offset = primitiveInfo.get(innerType)[0];
            this.elemSize = primitiveInfo.get(innerType)[1];
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }
}

