/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.protocol.tars.support;

import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.protocol.util.TarsHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AnalystManager {
    private ConcurrentHashMap<String, Map<Method, TarsMethodInfo>> cache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Map<String, TarsMethodInfo>> context_cache = new ConcurrentHashMap();
    private static final AnalystManager instance = new AnalystManager();

    public static AnalystManager getInstance() {
        return instance;
    }

    public Map<Method, TarsMethodInfo> getMethodMap(Class<?> api) {
        return this.cache.get(api.getName());
    }

    public void registry(Class<?> api, String objName) {
        this.cache.putIfAbsent(api.getName(), TarsHelper.getMethodInfo(api, objName));
    }

    public Map<String, TarsMethodInfo> getMethodMapByName(String objName) {
        return this.context_cache.get(objName);
    }

    public void registry(String contextName, Class<?> api, String objName) {
        Map<Method, TarsMethodInfo> methodsMap = TarsHelper.getMethodInfo(api, objName);
        if (methodsMap != null && !methodsMap.isEmpty()) {
            HashMap<String, TarsMethodInfo> methodMap = new HashMap<String, TarsMethodInfo>();
            for (Map.Entry<Method, TarsMethodInfo> entry : methodsMap.entrySet()) {
                methodMap.put(entry.getKey().getName(), entry.getValue());
            }
            this.context_cache.putIfAbsent(objName, methodMap);
        }
    }
}

