/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorDataRefresh
extends AbstractDataRefresh<SelectorData> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorDataRefresh.class);
    private final PluginDataSubscriber pluginDataSubscriber;

    public SelectorDataRefresh(PluginDataSubscriber pluginDataSubscriber) {
        this.pluginDataSubscriber = pluginDataSubscriber;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.SELECTOR.name());
    }

    @Override
    protected ConfigData<SelectorData> fromJson(JsonObject data) {
        return (ConfigData)GsonUtils.getGson().fromJson((JsonElement)data, new TypeToken<ConfigData<SelectorData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<SelectorData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.SELECTOR);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.SELECTOR);
    }

    @Override
    protected void refresh(List<SelectorData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all selector cache, old cache");
            data.forEach(arg_0 -> ((PluginDataSubscriber)this.pluginDataSubscriber).unSelectorSubscribe(arg_0));
            this.pluginDataSubscriber.refreshSelectorDataAll();
        } else {
            this.pluginDataSubscriber.refreshSelectorDataAll();
            data.forEach(arg_0 -> ((PluginDataSubscriber)this.pluginDataSubscriber).onSelectorSubscribe(arg_0));
        }
    }
}

