/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.builder;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.Objects;
import org.apache.shenyu.common.dto.convert.rule.HystrixHandle;

public final class HystrixBuilder {
    private HystrixBuilder() {
    }

    public static HystrixObservableCommand.Setter build(HystrixHandle hystrixHandle, String commandKey, String groupKey) {
        HystrixBuilder.initHystrixHandleOnRequire(hystrixHandle);
        HystrixCommandGroupKey hystrixCommandGroupKey = HystrixCommandGroupKey.Factory.asKey((String)groupKey);
        HystrixCommandKey hystrixCommandKey = HystrixCommandKey.Factory.asKey((String)commandKey);
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds((int)hystrixHandle.getTimeout()).withCircuitBreakerEnabled(true).withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(hystrixHandle.getMaxConcurrentRequests()).withCircuitBreakerErrorThresholdPercentage(hystrixHandle.getErrorThresholdPercentage()).withCircuitBreakerRequestVolumeThreshold(hystrixHandle.getRequestVolumeThreshold()).withCircuitBreakerSleepWindowInMilliseconds(hystrixHandle.getSleepWindowInMilliseconds());
        return HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)hystrixCommandGroupKey).andCommandKey(hystrixCommandKey).andCommandPropertiesDefaults(propertiesSetter);
    }

    public static HystrixObservableCommand.Setter build(HystrixHandle hystrixHandle) {
        return HystrixBuilder.build(hystrixHandle, hystrixHandle.getCommandKey(), hystrixHandle.getGroupKey());
    }

    public static HystrixCommand.Setter buildForHystrixCommand(HystrixHandle hystrixHandle) {
        return HystrixBuilder.buildForHystrixCommand(hystrixHandle, hystrixHandle.getCommandKey(), hystrixHandle.getGroupKey());
    }

    public static HystrixCommand.Setter buildForHystrixCommand(HystrixHandle hystrixHandle, String commandKey, String groupKey) {
        HystrixBuilder.initHystrixHandleOnRequire(hystrixHandle);
        HystrixCommandGroupKey hystrixCommandGroupKey = HystrixCommandGroupKey.Factory.asKey((String)groupKey);
        HystrixCommandKey hystrixCommandKey = HystrixCommandKey.Factory.asKey((String)commandKey);
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds((int)hystrixHandle.getTimeout()).withCircuitBreakerEnabled(true).withCircuitBreakerErrorThresholdPercentage(hystrixHandle.getErrorThresholdPercentage()).withCircuitBreakerRequestVolumeThreshold(hystrixHandle.getRequestVolumeThreshold()).withCircuitBreakerSleepWindowInMilliseconds(hystrixHandle.getSleepWindowInMilliseconds());
        HystrixHandle.HystrixThreadPoolConfig hystrixThreadPoolConfig = hystrixHandle.getHystrixThreadPoolConfig();
        HystrixThreadPoolProperties.Setter threadPoolPropertiesSetter = HystrixThreadPoolProperties.Setter().withCoreSize(hystrixThreadPoolConfig.getCoreSize()).withMaximumSize(hystrixThreadPoolConfig.getMaximumSize()).withMaxQueueSize(hystrixThreadPoolConfig.getMaxQueueSize()).withKeepAliveTimeMinutes(hystrixThreadPoolConfig.getKeepAliveTimeMinutes()).withAllowMaximumSizeToDivergeFromCoreSize(true);
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hystrixCommandGroupKey).andCommandKey(hystrixCommandKey).andCommandPropertiesDefaults(propertiesSetter).andThreadPoolPropertiesDefaults(threadPoolPropertiesSetter);
    }

    private static void initHystrixHandleOnRequire(HystrixHandle hystrixHandle) {
        HystrixHandle.HystrixThreadPoolConfig hystrixThreadPoolConfig;
        if (hystrixHandle.getMaxConcurrentRequests() == 0) {
            hystrixHandle.setMaxConcurrentRequests(100);
        }
        if (hystrixHandle.getErrorThresholdPercentage() == 0) {
            hystrixHandle.setErrorThresholdPercentage(50);
        }
        if (hystrixHandle.getRequestVolumeThreshold() == 0) {
            hystrixHandle.setRequestVolumeThreshold(20);
        }
        if (hystrixHandle.getSleepWindowInMilliseconds() == 0) {
            hystrixHandle.setSleepWindowInMilliseconds(5000);
        }
        if (Objects.isNull(hystrixHandle.getHystrixThreadPoolConfig())) {
            hystrixHandle.setHystrixThreadPoolConfig(new HystrixHandle.HystrixThreadPoolConfig());
        }
        if ((hystrixThreadPoolConfig = hystrixHandle.getHystrixThreadPoolConfig()).getCoreSize() == 0) {
            hystrixThreadPoolConfig.setCoreSize(10);
        }
        if (hystrixThreadPoolConfig.getMaximumSize() == 0) {
            hystrixThreadPoolConfig.setMaximumSize(10);
        }
        if (hystrixThreadPoolConfig.getMaxQueueSize() == 0) {
            hystrixThreadPoolConfig.setMaxQueueSize(12);
        }
    }
}

