/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;

class DefaultHyperLogLogOperations<K, V>
extends AbstractOperations<K, V>
implements HyperLogLogOperations<K, V> {
    DefaultHyperLogLogOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Long add(K key, V ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.pfAdd(rawKey, rawValues));
    }

    @Override
    public Long size(K ... keys) {
        byte[][] rawKeys = this.rawKeys(Arrays.asList(keys));
        return this.execute(connection -> connection.pfCount(rawKeys));
    }

    @Override
    public Long union(K destination, K ... sourceKeys) {
        byte[] rawDestinationKey = this.rawKey(destination);
        byte[][] rawSourceKeys = this.rawKeys(Arrays.asList(sourceKeys));
        return this.execute(connection -> {
            connection.pfMerge(rawDestinationKey, rawSourceKeys);
            return connection.pfCount(new byte[][]{rawDestinationKey});
        });
    }

    @Override
    public void delete(K key) {
        this.template.delete(key);
    }
}

