/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorUser;
import org.casbin.casdoor.exception.CasdoorException;
import org.casbin.casdoor.util.UserOperations;
import org.casbin.casdoor.util.http.CasdoorResponse;
import org.casbin.casdoor.util.http.HttpClient;

public class CasdoorUserService {
    private final CasdoorConfig casdoorConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CasdoorUserService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CasdoorUser[] getUsers() throws IOException {
        String targetUrl = String.format("%s/api/get-users?owner=%s&clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        String response = this.getUserResponse(targetUrl);
        return (CasdoorUser[])this.objectMapper.readValue(response, CasdoorUser[].class);
    }

    public CasdoorUser[] getSortedUsers(String sorter, int limit) throws IOException {
        String targetUrl = String.format("%s/api/get-sorted-users?owner=%s&clientId=%s&clientSecret=%s&sorter=%s&limit=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret(), sorter, limit);
        String response = this.getUserResponse(targetUrl);
        return (CasdoorUser[])this.objectMapper.readValue(response, CasdoorUser[].class);
    }

    public int getUserCount(String isOnline) throws IOException {
        String targetUrl = String.format("%s/api/get-user-count?owner=%s&clientId=%s&clientSecret=%s&isOnline=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret(), isOnline);
        String response = this.getUserResponse(targetUrl);
        return (Integer)this.objectMapper.readValue(response, Integer.class);
    }

    public CasdoorUser getUser(String name) throws IOException {
        String targetUrl = String.format("%s/api/get-user?id=%s/%s&clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), name, this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        String response = this.getUserResponse(targetUrl);
        return (CasdoorUser)this.objectMapper.readValue(response, CasdoorUser.class);
    }

    public CasdoorUser getUserByEmail(String email) throws IOException {
        String targetUrl = String.format("%s/api/get-user?owner=%s&clientId=%s&clientSecret=%s&email=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret(), email);
        String response = this.getUserResponse(targetUrl);
        return (CasdoorUser)this.objectMapper.readValue(response, CasdoorUser.class);
    }

    private String getUserResponse(String targetUrl) throws IOException {
        String response = HttpClient.syncGet(targetUrl);
        if (response == null) {
            throw new CasdoorException("Connection timeout.");
        }
        return response;
    }

    public CasdoorResponse updateUser(CasdoorUser casdoorUser) throws IOException {
        return this.modifyUser(UserOperations.UPDATE_USER, casdoorUser);
    }

    public CasdoorResponse addUser(CasdoorUser casdoorUser) throws IOException {
        return this.modifyUser(UserOperations.ADD_USER, casdoorUser);
    }

    public CasdoorResponse deleteUser(CasdoorUser casdoorUser) throws IOException {
        return this.modifyUser(UserOperations.DELETE_USER, casdoorUser);
    }

    private CasdoorResponse modifyUser(UserOperations method, CasdoorUser casdoorUser) throws IOException {
        String targetUrl = String.format("%s/api/%s?id=%s/%s&clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), method.getOperation(), casdoorUser.getOwner(), casdoorUser.getName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        String userStr = this.objectMapper.writeValueAsString((Object)casdoorUser);
        String responseStr = HttpClient.postString(targetUrl, userStr);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }
}

