/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.http.Http1ServerChannelHandler;
import com.alipay.sofa.rpc.transport.http.Http2ChannelHandlerBuilder;
import com.alipay.sofa.rpc.transport.http.Http2ServerUpgradeHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AsciiString;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;

public class Http2ServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2ServerChannelInitializer.class);
    private final EventLoopGroup bizGroup;
    private final HttpServerHandler serverHandler;
    private final SslContext sslCtx;
    private final int maxHttpContentLength;

    public Http2ServerChannelInitializer(EventLoopGroup bizGroup, SslContext sslCtx, HttpServerHandler serverHandler, int maxHttpContentLength) {
        if (maxHttpContentLength < 0) {
            throw new IllegalArgumentException("maxHttpContentLength (expected >= 0): " + maxHttpContentLength);
        }
        this.bizGroup = bizGroup;
        this.sslCtx = sslCtx;
        this.maxHttpContentLength = maxHttpContentLength;
        this.serverHandler = serverHandler;
    }

    public void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            this.configureSSL(ch);
        } else {
            this.configureClearText(ch);
        }
    }

    private void configureSSL(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        p.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
                if ("h2".equals(protocol)) {
                    ctx.pipeline().addLast((EventExecutorGroup)Http2ServerChannelInitializer.this.bizGroup, "Http2ChannelHandler", (ChannelHandler)new Http2ChannelHandlerBuilder(Http2ServerChannelInitializer.this.serverHandler).build());
                    return;
                }
                if ("http/1.1".equals(protocol)) {
                    ctx.pipeline().addLast("HttpServerCodec", (ChannelHandler)new HttpServerCodec());
                    ctx.pipeline().addLast("HttpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(Http2ServerChannelInitializer.this.maxHttpContentLength));
                    ctx.pipeline().addLast((EventExecutorGroup)Http2ServerChannelInitializer.this.bizGroup, "Http1ChannelHandler", (ChannelHandler)new Http1ServerChannelHandler(Http2ServerChannelInitializer.this.serverHandler));
                    return;
                }
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }});
    }

    private void configureClearText(final SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return new Http2ServerUpgradeCodec((Http2ConnectionHandler)new Http2ChannelHandlerBuilder(Http2ServerChannelInitializer.this.serverHandler).build());
                }
                return null;
            }
        });
        Http2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new Http2ServerUpgradeHandler(this.bizGroup, sourceCodec, upgradeHandler, (ChannelHandler)new Http2ChannelHandlerBuilder(this.serverHandler).build());
        p.addLast("Http2ServerUpgradeHandler", (ChannelHandler)cleartextHttp2ServerUpgradeHandler);
        p.addLast("HttpDirectTalkingHandler", (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Directly talking: {} (no upgrade was attempted) from {}", msg.protocolVersion(), NetUtil.toSocketAddressString((InetSocketAddress)ch.remoteAddress()));
                }
                ChannelPipeline pipeline = ctx.pipeline();
                ChannelHandlerContext thisCtx = pipeline.context((ChannelHandler)this);
                pipeline.addAfter((EventExecutorGroup)Http2ServerChannelInitializer.this.bizGroup, thisCtx.name(), "Http1ChannelHandler", (ChannelHandler)new Http1ServerChannelHandler(Http2ServerChannelInitializer.this.serverHandler));
                pipeline.replace((ChannelHandler)this, "HttpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(Http2ServerChannelInitializer.this.maxHttpContentLength));
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        });
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User Event Triggered: {}", evt);
            }
            ctx.fireUserEventTriggered(evt);
        }
    }
}

