/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractProxyClientTransport
extends ClientTransport {
    private Object proxy;
    private boolean open;
    protected InetSocketAddress localAddress;
    protected InetSocketAddress remoteAddress;
    protected volatile AtomicInteger currentRequests = new AtomicInteger(0);

    public AbstractProxyClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
        ProviderInfo provider = transportConfig.getProviderInfo();
        try {
            this.proxy = this.buildProxy(transportConfig);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020010009"), e);
        }
        this.open = this.proxy != null && NetUtils.canTelnet(provider.getHost(), provider.getPort(), transportConfig.getConnectTimeout());
        this.remoteAddress = InetSocketAddress.createUnresolved(provider.getHost(), provider.getPort());
        this.localAddress = InetSocketAddress.createUnresolved(SystemInfo.getLocalHost(), 0);
    }

    protected abstract Object buildProxy(ClientTransportConfig var1) throws SofaRpcException;

    @Override
    public void connect() {
        ProviderInfo provider = this.transportConfig.getProviderInfo();
        this.open = NetUtils.canTelnet(provider.getHost(), provider.getPort(), this.transportConfig.getConnectTimeout());
    }

    @Override
    public void disconnect() {
        this.open = false;
    }

    @Override
    public void destroy() {
        this.disconnect();
    }

    @Override
    public boolean isAvailable() {
        return this.open;
    }

    @Override
    public void setChannel(AbstractChannel channel) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public AbstractChannel getChannel() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int currentRequests() {
        return 0;
    }

    @Override
    public ResponseFuture asyncSend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Unsupported asynchronous RPC in short connection");
    }

    protected abstract Method getMethod(SofaRequest var1) throws SofaRpcException;

    @Override
    public SofaResponse syncSend(SofaRequest request, int timeout) throws SofaRpcException {
        RpcInternalContext context = RpcInternalContext.getContext();
        SofaResponse response = null;
        SofaRpcException throwable = null;
        try {
            this.beforeSend(context, request);
            if (EventBus.isEnable(ClientBeforeSendEvent.class)) {
                EventBus.post(new ClientBeforeSendEvent(request));
            }
            SofaResponse sofaResponse = response = this.doInvokeSync(request, timeout);
            return sofaResponse;
        }
        catch (InvocationTargetException e) {
            throwable = this.convertToRpcException(e);
            throw throwable;
        }
        catch (SofaRpcException e) {
            throwable = e;
            throw e;
        }
        catch (Exception e) {
            throwable = new SofaRpcException(299, "Failed to send message to remote", e);
            throw throwable;
        }
        finally {
            this.afterSend(context, request);
            if (EventBus.isEnable(ClientSyncReceiveEvent.class)) {
                EventBus.post(new ClientSyncReceiveEvent(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), request, response, throwable));
            }
        }
    }

    protected SofaResponse doInvokeSync(SofaRequest request, int timeoutMillis) throws InvocationTargetException, IllegalAccessException {
        SofaResponse response = new SofaResponse();
        Method method = this.getMethod(request);
        if (method == null) {
            throw new SofaRpcException(299, "Not found method :" + request.getInterfaceName() + "." + request.getMethodName());
        }
        Object o = method.invoke(this.proxy, request.getMethodArgs());
        response.setAppResponse(o);
        return response;
    }

    protected void beforeSend(RpcInternalContext context, SofaRequest request) {
        this.currentRequests.incrementAndGet();
        context.setLocalAddress(this.localAddress());
    }

    protected void afterSend(RpcInternalContext context, SofaRequest request) {
        this.currentRequests.decrementAndGet();
    }

    protected SofaRpcException convertToRpcException(InvocationTargetException e) {
        SofaRpcException exception;
        Throwable ie = e.getCause();
        if (ie != null) {
            Throwable realException = ie.getCause();
            if (realException != null) {
                if (realException instanceof SocketTimeoutException) {
                    exception = new SofaRpcException(200, "Client read timeout!", realException);
                } else if (realException instanceof ConnectException) {
                    this.open = false;
                    exception = new SofaRpcException(250, "Connect to remote " + this.transportConfig.getProviderInfo() + " error!", realException);
                } else {
                    exception = new SofaRpcException(299, "Send message to remote catch error: " + realException.getMessage(), realException);
                }
            } else {
                exception = new SofaRpcException(299, "Send message to remote catch error: " + ie.getMessage(), ie);
            }
        } else {
            exception = new SofaRpcException(299, "Send message to remote catch error: " + e.getMessage(), e);
        }
        return exception;
    }

    @Override
    public void oneWaySend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void receiveRpcResponse(SofaResponse response) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void handleRpcRequest(SofaRequest request) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }
}

