/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.proxy.bytebuddy;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.proxy.Proxy;
import com.alipay.sofa.rpc.proxy.bytebuddy.BytebuddyInvocationHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@Extension(value="bytebuddy")
public class BytebuddyProxy
implements Proxy {
    private boolean disableCache = false;
    private static final Map<Class, Class> PROXY_CLASS_MAP = new ConcurrentHashMap<Class, Class>();

    public BytebuddyProxy() {
        String disableCacheStr = System.getProperty("sofa.rpc.proxy.disableCache");
        if (disableCacheStr != null) {
            this.disableCache = Boolean.parseBoolean(disableCacheStr);
        }
    }

    @Override
    public <T> T getProxy(Class<T> interfaceClass, Invoker proxyInvoker) {
        Class cls = null;
        if (!this.disableCache) {
            cls = PROXY_CLASS_MAP.get(interfaceClass);
        }
        if (cls == null) {
            cls = new ByteBuddy().subclass(interfaceClass).method((ElementMatcher)ElementMatchers.isDeclaredBy(interfaceClass).or((ElementMatcher)ElementMatchers.isEquals()).or((ElementMatcher)ElementMatchers.isToString().or((ElementMatcher)ElementMatchers.isHashCode()))).intercept((Implementation)MethodDelegation.to((Object)new BytebuddyInvocationHandler(proxyInvoker), (String)"handler")).make().load(interfaceClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            PROXY_CLASS_MAP.put(interfaceClass, cls);
        }
        try {
            return cls.newInstance();
        }
        catch (Throwable t) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010080001", "bytebuddy"), t);
        }
    }

    @Override
    public Invoker getInvoker(Object proxyObject) {
        return BytebuddyProxy.parseInvoker(proxyObject);
    }

    public static Invoker parseInvoker(Object proxyObject) {
        try {
            Field field = proxyObject.getClass().getField("handler");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            BytebuddyInvocationHandler interceptor = (BytebuddyInvocationHandler)field.get(proxyObject);
            return interceptor.getProxyInvoker();
        }
        catch (Exception e) {
            return null;
        }
    }
}

