/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.HashUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

@Extension(value="weightConsistentHash")
public class WeightConsistentHashLoadBalancer
extends AbstractLoadBalancer {
    private final ConcurrentHashMap<String, Selector> selectorCache = new ConcurrentHashMap();

    public WeightConsistentHashLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest request, List<ProviderInfo> providerInfos) {
        String interfaceId = request.getInterfaceName();
        String method = request.getMethodName();
        String key = interfaceId + "#" + method;
        int hashcode = providerInfos.hashCode();
        Selector selector = this.selectorCache.get(key);
        if (selector == null || selector.getHashCode() != hashcode) {
            selector = new Selector(interfaceId, method, providerInfos, hashcode);
            this.selectorCache.put(key, selector);
        }
        return selector.select(request);
    }

    private static class Selector {
        private final int hashcode;
        private final String interfaceId;
        private final String method;
        private final TreeMap<Long, ProviderInfo> virtualNodes;

        public Selector(String interfaceId, String method, List<ProviderInfo> actualNodes) {
            this(interfaceId, method, actualNodes, actualNodes.hashCode());
        }

        public Selector(String interfaceId, String method, List<ProviderInfo> actualNodes, int hashcode) {
            this.interfaceId = interfaceId;
            this.method = method;
            this.hashcode = hashcode;
            this.virtualNodes = new TreeMap();
            int num = 32;
            for (ProviderInfo providerInfo : actualNodes) {
                for (int i = 0; i < num * providerInfo.getWeight() / 4; ++i) {
                    byte[] digest = HashUtils.messageDigest(providerInfo.getHost() + providerInfo.getPort() + i);
                    for (int h = 0; h < 4; ++h) {
                        long m = HashUtils.hash(digest, h);
                        this.virtualNodes.put(m, providerInfo);
                    }
                }
            }
        }

        public ProviderInfo select(SofaRequest request) {
            String key = this.buildKeyOfHash(request.getMethodArgs());
            byte[] digest = HashUtils.messageDigest(key);
            return this.selectForKey(HashUtils.hash(digest, 0));
        }

        private String buildKeyOfHash(Object[] args) {
            if (CommonUtils.isEmpty(args)) {
                return "";
            }
            return StringUtils.toString(args[0]);
        }

        private ProviderInfo selectForKey(long hash) {
            Map.Entry<Long, ProviderInfo> entry = this.virtualNodes.ceilingEntry(hash);
            if (entry == null) {
                entry = this.virtualNodes.firstEntry();
            }
            return entry.getValue();
        }

        public int getHashCode() {
            return this.hashcode;
        }
    }
}

