/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeInt16;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeString;

public class TypeInt32
implements BreezeType<Integer> {
    TypeInt32() {
    }

    public static int readInt32(BreezeBuffer buffer) {
        return buffer.getZigzag32();
    }

    @Override
    public byte getType() {
        return 127;
    }

    @Override
    public Integer read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return TypeInt32.readInt32(buffer);
        }
        byte type = buffer.get();
        if (type >= 64 && type <= 126) {
            return type - 80;
        }
        switch (type) {
            case 127: {
                return TypeInt32.readInt32(buffer);
            }
            case 63: {
                return Integer.parseInt(TypeString.readString(buffer));
            }
            case -104: {
                return (int)TypeInt64.readInt64(buffer);
            }
            case -98: {
                return TypeInt16.readInt16(buffer);
            }
        }
        throw new BreezeException("Breeze cannot convert to Integer. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, Integer value, boolean withType) throws BreezeException {
        if (withType) {
            if (value >= -16 && value <= 46) {
                buffer.put((byte)(value + 80));
                return;
            }
            buffer.put((byte)127);
        }
        buffer.putZigzag32(value);
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Integer field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null) {
            if (checkDefault && field == 0) {
                return;
            }
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

