/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.TypePackedArray;
import com.weibo.breeze.type.TypePackedMap;
import com.weibo.breeze.type.Types;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class BreezeWriter {
    public static int MAX_WRITE_COUNT = 0;
    public static boolean IS_PACK = true;

    public static void writeString(BreezeBuffer buffer, String str) throws BreezeException {
        Types.TYPE_STRING.write(buffer, str);
    }

    public static void writeBytes(BreezeBuffer buffer, byte[] value) throws BreezeException {
        Types.TYPE_BYTE_ARRAY.write(buffer, value);
    }

    public static void writeBool(BreezeBuffer buffer, boolean value) throws BreezeException {
        Types.TYPE_BOOL.write(buffer, value);
    }

    public static void writeByte(BreezeBuffer buffer, byte value) throws BreezeException {
        Types.TYPE_BYTE.write(buffer, value);
    }

    public static void writeInt16(BreezeBuffer buffer, short value) throws BreezeException {
        Types.TYPE_INT16.write(buffer, value);
    }

    public static void writeInt32(BreezeBuffer buffer, int value) throws BreezeException {
        Types.TYPE_INT32.write(buffer, value);
    }

    public static void writeInt64(BreezeBuffer buffer, long value) throws BreezeException {
        Types.TYPE_INT64.write(buffer, value);
    }

    public static void writeFloat32(BreezeBuffer buffer, float value) throws BreezeException {
        Types.TYPE_FLOAT32.write(buffer, Float.valueOf(value));
    }

    public static void writeFloat64(BreezeBuffer buffer, double value) throws BreezeException {
        Types.TYPE_FLOAT64.write(buffer, value);
    }

    public static void writeMessage(BreezeBuffer buffer, WriteField writeField) throws BreezeException {
        int pos = buffer.position();
        buffer.position(pos + 4);
        writeField.writeIndexFields();
        int newPos = buffer.position();
        buffer.position(pos);
        buffer.putInt(newPos - pos - 4);
        buffer.position(newPos);
    }

    public static void writeMessageField(BreezeBuffer buffer, Integer index, Object field) throws BreezeException {
        if (field != null) {
            buffer.putVarint(index.intValue());
            BreezeWriter.writeObject(buffer, field);
        }
    }

    public static void writeSchema(BreezeBuffer buffer, Schema schema) throws BreezeException {
    }

    public static void writeObject(BreezeBuffer buffer, Object object) throws BreezeException {
        if (object == null) {
            buffer.put((byte)-103);
            return;
        }
        if (object instanceof Message) {
            BreezeWriter.checkWriteCount(buffer, object);
            Message message = (Message)object;
            BreezeWriter.putMessageType(buffer, message.messageName());
            message.writeToBuf(buffer);
            return;
        }
        Class<?> clz = object.getClass();
        if (clz == String.class || clz == Character.class) {
            BreezeWriter.writeString(buffer, String.valueOf(object));
            return;
        }
        if (clz == Integer.class) {
            BreezeWriter.writeInt32(buffer, (Integer)object);
            return;
        }
        if (object instanceof Map) {
            BreezeWriter.checkWriteCount(buffer, object);
            BreezeWriter.writeMap(buffer, (Map)object);
            return;
        }
        if (object instanceof Collection) {
            BreezeWriter.checkWriteCount(buffer, object);
            BreezeWriter.writeCollection(buffer, (Collection)object);
            return;
        }
        if (clz == Boolean.class) {
            BreezeWriter.writeBool(buffer, (Boolean)object);
            return;
        }
        if (clz == Long.class) {
            BreezeWriter.writeInt64(buffer, (Long)object);
            return;
        }
        if (clz == Float.class) {
            BreezeWriter.writeFloat32(buffer, ((Float)object).floatValue());
            return;
        }
        if (clz == Double.class) {
            BreezeWriter.writeFloat64(buffer, (Double)object);
            return;
        }
        if (clz == Byte.class) {
            BreezeWriter.writeByte(buffer, (Byte)object);
            return;
        }
        if (clz == Short.class) {
            BreezeWriter.writeInt16(buffer, (Short)object);
            return;
        }
        if (clz.isArray()) {
            if (clz.getComponentType() == Byte.TYPE) {
                BreezeWriter.writeBytes(buffer, (byte[])object);
            } else {
                BreezeWriter.checkWriteCount(buffer, object);
                if (clz.getComponentType().isPrimitive()) {
                    Object[] objects = new Object[Array.getLength(object)];
                    for (int i = 0; i < objects.length; ++i) {
                        objects[i] = Array.get(object, i);
                    }
                    BreezeWriter.writeArray(buffer, objects);
                } else {
                    BreezeWriter.writeArray(buffer, (Object[])object);
                }
            }
            return;
        }
        Serializer serializer = Breeze.getSerializer(object.getClass());
        if (serializer != null) {
            BreezeWriter.checkWriteCount(buffer, object);
            BreezeWriter.putMessageType(buffer, serializer.getName());
            serializer.writeToBuf(object, buffer);
            return;
        }
        throw new BreezeException("Breeze unsupported type: " + clz);
    }

    public static void writeMap(BreezeBuffer buffer, Map<?, ?> value) throws BreezeException {
        if (IS_PACK) {
            TypePackedMap mapType = new TypePackedMap();
            mapType.write(buffer, value);
        } else {
            Types.TYPE_MAP.write(buffer, value);
        }
    }

    public static void writeArray(BreezeBuffer buffer, Object[] value) throws BreezeException {
        Types.TYPE_ARRAY.writeArray(buffer, value, true);
    }

    public static void writeCollection(BreezeBuffer buffer, Collection<?> value) throws BreezeException {
        if (IS_PACK) {
            TypePackedArray arrayType = new TypePackedArray();
            arrayType.writeCollection(buffer, value, true);
        } else {
            Types.TYPE_ARRAY.writeCollection(buffer, value, true);
        }
    }

    public static void checkWriteCount(BreezeBuffer buffer, Object object) throws BreezeException {
        int count;
        if (MAX_WRITE_COUNT > 0 && !(object instanceof Enum) && (count = buffer.getContext().writeCount(System.identityHashCode(object))) > MAX_WRITE_COUNT) {
            throw new BreezeException("maybe circular reference\u3002class:" + object.getClass());
        }
    }

    public static void putMessageType(BreezeBuffer buffer, String name) throws BreezeException {
        Integer index = buffer.getContext().getMessageTypeIndex(name);
        if (index == null) {
            buffer.put((byte)-34);
            Types.TYPE_STRING.write(buffer, name, false);
            buffer.getContext().putMessageType(name);
        } else if (index > 32) {
            buffer.put((byte)-33);
            buffer.putVarint(index.intValue());
        } else {
            buffer.put((byte)(-33 + index));
        }
    }

    @FunctionalInterface
    public static interface WriteField {
        public void writeIndexFields() throws BreezeException;
    }
}

