/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.config.ssl;

import io.netty.util.AsyncMapping;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.shenyu.common.config.ssl.SslCrtAndKey;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyFile;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.exception.ShenyuException;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpSslContextSpec;

public class ShenyuSniAsyncMapping
implements AsyncMapping<String, SslProvider> {
    private final ConcurrentHashMap<String, SslProvider> sslProviderMap;

    public ShenyuSniAsyncMapping() {
        this.sslProviderMap = new ConcurrentHashMap();
    }

    public ShenyuSniAsyncMapping(List<SslCrtAndKeyFile> sslCrtAndKeys) {
        if (Objects.isNull(sslCrtAndKeys) || sslCrtAndKeys.isEmpty()) {
            throw new ShenyuException("The sslCrtAndKeys can not be null");
        }
        this.sslProviderMap = new ConcurrentHashMap();
        sslCrtAndKeys.forEach(sslCrtAndKey -> {
            Http11SslContextSpec sslContextSpec = Http11SslContextSpec.forServer((File)new File(sslCrtAndKey.getKeyCertChainFile()), (File)new File(sslCrtAndKey.getKeyFile()));
            SslProvider sslProvider = SslProvider.builder().sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec).build();
            this.sslProviderMap.put(sslCrtAndKey.getDomain(), sslProvider);
        });
    }

    public void addSslProvider(String domain, SslProvider sslProvider) {
        this.sslProviderMap.put(domain, sslProvider);
    }

    public void addSslCertificate(SslCrtAndKey sslCrtAndKey) throws IOException {
        if (sslCrtAndKey instanceof SslCrtAndKeyFile) {
            SslCrtAndKeyFile sslCrtAndKeyFile = (SslCrtAndKeyFile)sslCrtAndKey;
            TcpSslContextSpec sslContextSpec = TcpSslContextSpec.forServer((File)new File(sslCrtAndKeyFile.getKeyCertChainFile()), (File)new File(sslCrtAndKeyFile.getKeyFile()));
            SslProvider sslProvider = SslProvider.builder().sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec).build();
            this.sslProviderMap.put(sslCrtAndKeyFile.getDomain(), sslProvider);
        } else if (sslCrtAndKey instanceof SslCrtAndKeyStream) {
            SslCrtAndKeyStream sslCrtAndKeyStream = (SslCrtAndKeyStream)sslCrtAndKey;
            sslCrtAndKeyStream.getKeyCertChainInputStream().reset();
            sslCrtAndKeyStream.getKeyInputStream().reset();
            TcpSslContextSpec sslContextSpec = TcpSslContextSpec.forServer((InputStream)sslCrtAndKeyStream.getKeyCertChainInputStream(), (InputStream)sslCrtAndKeyStream.getKeyInputStream());
            SslProvider sslProvider = SslProvider.builder().sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec).build();
            this.sslProviderMap.put(sslCrtAndKeyStream.getDomain(), sslProvider);
        }
    }

    public void removeSslCertificate(String domain) {
        this.sslProviderMap.remove(domain);
    }

    public Future<SslProvider> map(String domain, Promise<SslProvider> promise) {
        try {
            for (String key : this.sslProviderMap.keySet()) {
                if (!this.matchDomain(domain, key)) continue;
                return promise.setSuccess((Object)this.sslProviderMap.get(key));
            }
            return promise.setFailure((Throwable)new ShenyuException(String.format("Can not find ssl certificate of domain %s", domain)));
        }
        catch (Throwable cause) {
            return promise.setFailure(cause);
        }
    }

    private boolean matchDomain(String domain, String pattern) {
        return Pattern.matches(pattern.replace(".", "\\.").replace("*", ".*"), domain);
    }
}

