/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import com.weibo.api.motan.exception.MotanServiceException;
import java.nio.ByteBuffer;

public class GrowableByteBuffer {
    private ByteBuffer buf;

    public static int encodeZigZag32(int value) {
        return value << 1 ^ value >> 31;
    }

    public static long encodeZigZag64(long value) {
        return value << 1 ^ value >> 63;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public GrowableByteBuffer(int initSize) {
        this.buf = ByteBuffer.allocate(initSize);
    }

    public GrowableByteBuffer(ByteBuffer buf) {
        this.buf = buf;
    }

    public void put(byte b) {
        this.ensureBufferEnough(1);
        this.buf.put(b);
    }

    public void put(int index, byte b) {
        this.buf.put(index, b);
    }

    public void put(byte[] b) {
        this.ensureBufferEnough(b.length);
        this.buf.put(b);
    }

    public void putShort(short value) {
        this.ensureBufferEnough(2);
        this.buf.putShort(value);
    }

    public void putShort(int index, short value) {
        this.buf.putShort(index, value);
    }

    public void putInt(int value) {
        this.ensureBufferEnough(4);
        this.buf.putInt(value);
    }

    public void putInt(int index, int value) {
        this.buf.putInt(index, value);
    }

    public void putLong(long value) {
        this.ensureBufferEnough(8);
        this.buf.putLong(value);
    }

    public void putLong(int index, long value) {
        this.buf.putLong(index, value);
    }

    public void putFloat(float value) {
        this.ensureBufferEnough(4);
        this.buf.putFloat(value);
    }

    public void putFloat(int index, float value) {
        this.buf.putFloat(index, value);
    }

    public void putDouble(double value) {
        this.ensureBufferEnough(8);
        this.buf.putDouble(value);
    }

    public void putDouble(int index, double value) {
        this.buf.putDouble(index, value);
    }

    public int putZigzag32(int value) {
        return this.putVarint(GrowableByteBuffer.encodeZigZag32(value));
    }

    public int putZigzag64(long value) {
        return this.putVarint(GrowableByteBuffer.encodeZigZag64(value));
    }

    public int putVarint(long value) {
        int count = 0;
        while (true) {
            ++count;
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.put((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        this.put((byte)value);
        return count;
    }

    public byte get() {
        return this.buf.get();
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public void get(byte[] dst) {
        this.buf.get(dst);
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public short getShort(int index) {
        return this.buf.getShort(index);
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public int getInt(int index) {
        return this.buf.getInt(index);
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public long getLong(int index) {
        return this.buf.getLong(index);
    }

    public float getFloat() {
        return this.buf.getFloat();
    }

    public float getFloat(int index) {
        return this.buf.getFloat(index);
    }

    public double getDouble() {
        return this.buf.getDouble();
    }

    public double getDouble(int index) {
        return this.buf.getDouble(index);
    }

    public int getZigZag32() {
        return GrowableByteBuffer.decodeZigZag32((int)this.getVarint());
    }

    public long getZigZag64() {
        return GrowableByteBuffer.decodeZigZag64(this.getVarint());
    }

    public long getVarint() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.buf.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new MotanServiceException("Integer overflow");
    }

    public void flip() {
        this.buf.flip();
    }

    public int position() {
        return this.buf.position();
    }

    public void position(int newPosition) {
        this.ensureBufferEnough(newPosition - this.buf.position());
        this.buf.position(newPosition);
    }

    public int limit() {
        return this.buf.limit();
    }

    public void limit(int newLimit) {
        this.buf.limit(newLimit);
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public void clear() {
        this.buf.clear();
    }

    private ByteBuffer grow(int size) {
        ByteBuffer newbuf = ByteBuffer.allocate(size);
        newbuf.put(this.buf.array());
        newbuf.position(this.buf.position());
        return newbuf;
    }

    private void ensureBufferEnough(int need) {
        int expandSize = this.buf.position() + need;
        if (this.buf.capacity() < expandSize) {
            int size;
            for (size = this.buf.capacity() * 2; size < expandSize; size *= 2) {
            }
            this.buf = this.grow(size);
        }
    }
}

