/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.util.BaseReaderUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.swagger.generator.core.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ApiOperationProcessor
implements MethodAnnotationProcessor {
    private static final String SEPARATOR = ",";

    @Override
    public void process(Object annotation, OperationGenerator operationGenerator) {
        ApiOperation apiOperationAnnotation = (ApiOperation)annotation;
        Operation operation = operationGenerator.getOperation();
        operationGenerator.setHttpMethod(apiOperationAnnotation.httpMethod());
        if (!StringUtils.isEmpty((Object)apiOperationAnnotation.value())) {
            operation.setSummary(apiOperationAnnotation.value());
        }
        if (!StringUtils.isEmpty((Object)apiOperationAnnotation.notes())) {
            operation.setDescription(apiOperationAnnotation.notes());
        }
        operation.setOperationId(apiOperationAnnotation.nickname());
        operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperationAnnotation.extensions()));
        this.convertTags(apiOperationAnnotation.tags(), operation);
        this.convertProduces(apiOperationAnnotation.produces(), operation);
        this.convertConsumes(apiOperationAnnotation.consumes(), operation);
        this.convertProtocols(apiOperationAnnotation.protocols(), operation);
        AnnotationUtils.addResponse(operationGenerator.getSwagger(), operation, apiOperationAnnotation);
    }

    private void convertProtocols(String protocols, Operation operation) {
        if (protocols == null) {
            return;
        }
        for (String protocol : protocols.split(SEPARATOR)) {
            if (StringUtils.isEmpty((Object)protocol)) continue;
            operation.addScheme(Scheme.forValue((String)protocol));
        }
    }

    private void convertConsumes(String consumes, Operation operation) {
        if (StringUtils.isEmpty((Object)consumes)) {
            return;
        }
        List consumeList = Arrays.stream(consumes.split(SEPARATOR)).filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList());
        if (!consumeList.isEmpty()) {
            operation.setConsumes(consumeList);
        }
    }

    private void convertProduces(String produces, Operation operation) {
        if (StringUtils.isEmpty((Object)produces)) {
            return;
        }
        List produceList = Arrays.stream(produces.split(SEPARATOR)).filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList());
        if (!produceList.isEmpty()) {
            operation.setProduces(produceList);
        }
    }

    private void convertTags(String[] tags, Operation operation) {
        if (tags == null || tags.length == 0) {
            return;
        }
        for (String tag : tags) {
            if (StringUtils.isEmpty((Object)tag)) continue;
            operation.addTag(tag);
        }
    }
}

