/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.schema;

import java.util.Collection;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.provider.pojo.RpcSchema;
import org.apache.servicecomb.provider.pojo.schema.PojoProducerMeta;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PojoProducers
implements BeanPostProcessor {
    private RegisterManager<String, PojoProducerMeta> pojoMgr = new RegisterManager("pojo service manager");

    public void registerPojoProducer(PojoProducerMeta pojoProducer) {
        this.pojoMgr.register((Object)pojoProducer.getSchemaId(), (Object)pojoProducer);
    }

    public Collection<PojoProducerMeta> getProducers() {
        return this.pojoMgr.values();
    }

    @Deprecated
    public Collection<PojoProducerMeta> getProcucers() {
        return this.getProducers();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processProvider(beanName, bean);
        return bean;
    }

    protected void processProvider(String beanName, Object bean) {
        Class beanCls = BeanUtils.getImplClassFromBean((Object)bean);
        if (beanCls == null) {
            return;
        }
        RpcSchema rpcSchema = beanCls.getAnnotation(RpcSchema.class);
        if (rpcSchema == null) {
            return;
        }
        String schemaId = rpcSchema.schemaId();
        if (StringUtils.isEmpty((Object)schemaId)) {
            Class<?>[] intfs = beanCls.getInterfaces();
            if (intfs.length == 1) {
                schemaId = intfs[0].getName();
            } else {
                throw new Error("Must be schemaId or implements only one interface");
            }
        }
        PojoProducerMeta pojoProducerMeta = new PojoProducerMeta();
        pojoProducerMeta.setSchemaId(schemaId);
        pojoProducerMeta.setInstance(bean);
        pojoProducerMeta.setInstanceClass(beanCls);
        this.registerPojoProducer(pojoProducerMeta);
    }
}

