/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutor;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;

public class CommandExecutionAction
implements CommandAction {
    private HystrixInvokable hystrixCommand;
    private MetaHolder metaHolder;

    public CommandExecutionAction(HystrixInvokable hystrixCommand, MetaHolder metaHolder) {
        this.hystrixCommand = hystrixCommand;
        this.metaHolder = metaHolder;
    }

    @Override
    public MetaHolder getMetaHolder() {
        return this.metaHolder;
    }

    @Override
    public Object execute(ExecutionType executionType) throws CommandActionExecutionException {
        return CommandExecutor.execute(this.hystrixCommand, executionType, this.metaHolder);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) throws CommandActionExecutionException {
        return CommandExecutor.execute(this.hystrixCommand, executionType, this.metaHolder);
    }

    @Override
    public String getActionName() {
        if (this.hystrixCommand != null && this.hystrixCommand instanceof HystrixInvokableInfo) {
            HystrixInvokableInfo info = (HystrixInvokableInfo)this.hystrixCommand;
            return info.getCommandKey().name();
        }
        return "";
    }
}

