/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.rx;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.rx.SingleReturnValueHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import rx.Observable;
import rx.Single;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Observable.class})
public class RxJavaAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={AsyncHandlerMethodReturnValueHandler.class, WebMvcConfigurerAdapter.class})
    protected static class RxJavaReturnValueHandlerConfig {
        protected RxJavaReturnValueHandlerConfig() {
        }

        @Bean
        public SingleReturnValueHandler singleReturnValueHandler() {
            return new SingleReturnValueHandler();
        }

        @Bean
        public WebMvcConfigurerAdapter observableMVCConfiguration(final SingleReturnValueHandler singleReturnValueHandler) {
            return new WebMvcConfigurerAdapter(){

                public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
                    returnValueHandlers.add((HandlerMethodReturnValueHandler)singleReturnValueHandler);
                }
            };
        }

        @Bean
        public HasFeatures rxFeature() {
            return HasFeatures.namedFeatures((String)"MVC Observable", Observable.class, (String)"MVC Single", Single.class);
        }
    }
}

