/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.cloud.netflix.feign.support.FeignUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;

public class SpringEncoder
implements Encoder {
    private static final Log log = LogFactory.getLog(SpringEncoder.class);
    private ObjectFactory<HttpMessageConverters> messageConverters;

    public SpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (requestBody != null) {
            Class<?> requestType = requestBody.getClass();
            Collection contentTypes = (Collection)request.headers().get("Content-Type");
            MediaType requestContentType = null;
            if (contentTypes != null && !contentTypes.isEmpty()) {
                String type = (String)contentTypes.iterator().next();
                requestContentType = MediaType.valueOf((String)type);
            }
            for (HttpMessageConverter messageConverter : ((HttpMessageConverters)this.messageConverters.getObject()).getConverters()) {
                if (!messageConverter.canWrite(requestType, requestContentType)) continue;
                if (log.isDebugEnabled()) {
                    if (requestContentType != null) {
                        log.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
                    } else {
                        log.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
                    }
                }
                FeignOutputMessage outputMessage = new FeignOutputMessage(request);
                try {
                    HttpMessageConverter copy = messageConverter;
                    copy.write(requestBody, requestContentType, (HttpOutputMessage)outputMessage);
                }
                catch (IOException ex) {
                    throw new EncodeException("Error converting request body", (Throwable)ex);
                }
                request.headers(null);
                request.headers(FeignUtils.getHeaders(outputMessage.getHeaders()));
                if (messageConverter instanceof ByteArrayHttpMessageConverter) {
                    request.body(outputMessage.getOutputStream().toByteArray(), null);
                } else {
                    request.body(outputMessage.getOutputStream().toByteArray(), Charset.forName("UTF-8"));
                }
                return;
            }
            String message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestType.getName() + "]";
            if (requestContentType != null) {
                message = message + " and content type [" + requestContentType + "]";
            }
            throw new EncodeException(message);
        }
    }

    private class FeignOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final HttpHeaders httpHeaders;

        private FeignOutputMessage(RequestTemplate request) {
            this.httpHeaders = FeignUtils.getHttpHeaders(request.headers());
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

